
#include "converse.h"
#include "receiver.decl.h"

typedef void (* recvCallBack)(void *);

class receiverMsg: public CMessage_receiverMsg, public ArrayMessage
{
public:
  int tag;
  int sendFrom;
  int refno;
  int size;
  char *buf;

  static void *alloc(int mnum, size_t size, int *sizes, int pbits)
  {
    int stmp = sizes[0]*sizeof(char);
    receiverMsg *m = (receiverMsg *) CkAllocMsg(mnum, size+stmp, pbits);
    m->size = sizes[0];
    m->buf = (char *)((char *)m + size);
    return (void *)m;
  }

  static void *pack(receiverMsg *m)
  {
    return (void *)m;
  }

  static receiverMsg *unpack(void *buf)
  {
    receiverMsg *m = (receiverMsg *) buf;
    m->buf = (char *)((char *)m+sizeof(receiverMsg));
    return m;
  }
};

class receiver: public ArrayElement
{
private:
  CmmTable  msgTbl;
  CmmTable  reqTbl;
  int counter;

  recvCallBack callback;
  void *cb_data;

  typedef struct _tblEntry {
    char *buf;
    int size;
  } tblEntry;

  void recvAlready();

public:
  receiver(ArrayElementCreateMessage *);
  receiver(ArrayElementMigrateMessage *);
  ~receiver();

  void sendTo(int tag, char *pointer, int size, int from, int refno);
  // entry
  void generic(receiverMsg *);

  void irecv(int tag, char *pointer, int size, int senderTag, int refno);   
  void iwaitAll(recvCallBack f, void *data, int refno);
};

