/*****************************************************************************
 * $Source: /cvsroot/charm-5.8/src/ck-ldb/RandCentLB.C,v $
 * $Author: lixiashi $
 * $Date: 2003/12/17 02:12:00 $
 * $Revision: 1.26 $
 *****************************************************************************/

/**
 * \addtogroup CkLdb
*/
/*@{*/

/*
Status:
  * support nonmigratable attrib
  * support processor avail bitvector
*/

#include <charm++.h>

#include "cklists.h"

#include "RandCentLB.h"

CreateLBFunc_Def(RandCentLB);

static void lbinit(void) {
  LBRegisterBalancer("RandCentLB", CreateRandCentLB, AllocateRandCentLB, "Assign objects to processors randomly");
}

#include "RandCentLB.def.h"

RandCentLB::RandCentLB(const CkLBOptions &opt): CentralLB(opt)
{
  lbname = "RandCentLB";
  if (CkMyPe() == 0)
    CkPrintf("[%d] RandCentLB created\n",CkMyPe());
}

CmiBool RandCentLB::QueryBalanceNow(int _step)
{
  return CmiTrue;
}

inline int chooseProc(int count)
{
  return (int)(CrnDrand()*(count-1) + 0.5);
}

void RandCentLB::work(CentralLB::LDStats* stats, int count)
{
  int proc;
  for (proc=0; proc<count; proc++) {
    if (stats->procs[proc].available) break;
  }
  if (proc == count) CmiAbort("RandCentLB> no available processor!");

  int nmigrated = 0;
  for(int obj=0; obj < stats->n_objs; obj++) {
      LDObjData &odata = stats->objData[obj];
      if (odata.migratable) {
	int dest = chooseProc(count);
	while (!stats->procs[dest].available) dest = chooseProc(count);
	if (dest != stats->from_proc[obj]) {
          //CkPrintf("[%d] Obj %d migrating from %d to %d\n", CkMyPe(),obj,stats->from_proc[obj],dest);
          nmigrated ++;
	  stats->to_proc[obj] = dest;
        }
      }
  }
}


/*@}*/
