#include <stdio.h>
#include "cmSimulator/Random.h"
#include <unistd.h>

void default_options(){
    printf("emulator <server port> <mean arrival time> <number of jobs to simulate> <number or jobs to choose from>\n"); 
    exit(0);
}

struct Job{
    char path[256];
    int meanItr;
};

int main(int argc, char **argv){
    if(argc < 5)
	default_options();
    
    int port = atoi(argv[1]);
    double mean_arrival_time = atof(argv[2]);
    int njobs = atoi(argv[3]);
    int numjobtypes = atoi(argv[4]);

    Job * jobs = new Job[numjobtypes];

    for(int i = 0; i < numjobtypes; i++){
	printf("Job %d Path: ", i);
	scanf("%s", jobs[i].path);
	printf("Mean number of iterations to run this job: ");
	scanf("%d", &jobs[i].meanItr);
    }
    
    Random * arrival = new Random(mean_arrival_time, EXPONENTIAL);
    Random *type = new Random();
    Random * service = new Random(1.0, EXPONENTIAL);
    Random *processors = new Random();

    system("/bin/touch out");
    for(int count = 0; count < njobs; count++){

	int curtype = ((int)type->rand()) % numjobtypes;
	int jobitr = (int)(service->rand() * jobs[curtype].meanItr) + 1;
	int proc = (int)processors->rand()%16 + 1;

	char cmd[1024];
	sprintf(cmd, "./client localhost %d %s %d -minpe %d -type mcharm >> out &\n", port, jobs[curtype].path, jobitr, proc);
	
	//sprintf(cmd, "./client localhost %d %s %d -maxpe %d >> out &\n", port, jobs[curtype].path, jobitr, (proc + 16)/2);
	
	printf("%s\n", cmd);
	system(cmd);
	
	int sleeptime = (unsigned int)arrival->rand();
	printf("sleeping for %d\n", sleeptime);
	sleep(sleeptime);
    }
}

