#include "heap.h"
#include "scheduler.h"
#include "iostream.h"

#define MEAN_PROFIT 1000
#include "ProfitStrategy.h"

int MAX_JOBS = 10000;

Scheduler * scheduler;
minHeap * h;
double time;
double responseTime = 0.0;
double finishTime = 0.0;

int systemJobType = 0;
int njobs = 0;

Random *arrival, *minpe, *workgen, *profitgen, *deadlinegen; 

void generateArrival() {

    if(njobs > MAX_JOBS)
	return;

    njobs ++;
    Event * e = new Event();
    
    e->timeStamp = time + arrival->rand();

    e->eventType = ARRIVAL;
    e->job = NULL;
    e->count = 0;
    h->insert(e);
}

void processEvent(Event *e) {
    if (e->eventType == ARRIVAL){
	generateArrival();
	scheduler->handleArrival(e);
    }
    else if (e->eventType == JOBDONE) {
	if (e->job->count == e->count)
	    scheduler->handleJobDone(e);
	// else this is an obsolete completion event, obsoleted by a shrink/expand operation
    }
}

main(int argc, char **argv) {
    int nproc = 64;
    
    if(argc > 1)
	nproc = atoi(argv[1]);

    if(argc > 2)
	systemJobType = atoi(argv[2]);

    if(argc > 3)
	MAX_JOBS = atoi(argv[3]);
    
    scheduler = new Scheduler(nproc);
    h = new minHeap(1000000);
    time = 0.0;

    double load_factor = 1.0;
    if(argc > 4)
	load_factor = atof(argv[4]);

    srand(500);
    srandom(500);
    double mean_arrival_time =(MEAN_ITR * ITR_TIME + STARTUP_TIME)/load_factor;
    arrival = new Random(mean_arrival_time, EXPONENTIAL);
    
    workgen = new Random(MEAN_ITR, EXPONENTIAL);
    minpe = new Random();

    deadlinegen = new Random(MEAN_ITR, EXPONENTIAL);
    profitgen = new Random(MEAN_PROFIT, EXPONENTIAL);

    generateArrival();
    
    while (h->numElements() != 0) {
	Event *e = h->deleteMin();
	time = e->timeStamp;
	//	cout << "processing " << e->eventType << endl;
	processEvent(e);
    }
    /*
    printf("Number Of Jobs = %d\n", njobs);
    printf("Arrival Rate %5.3lf\n", arrival_rate);
    if(!systemJobType)
      printf("System is Migratable\n");
    else
      printf("System is not Migratable\n");

    printf("Average Scheduling Delay = %5.5lf\n", responseTime/njobs);
    printf("Average Response Time = %5.5lf\n", finishTime/njobs); 
    printf("Utilization = %5.3lf\n", scheduler->utilization);
    printf("Time of Last Event = %5.3lf\n", time);
    printf("queue size = %5.5lf\n", scheduler->qsize);
    */
    //printf("%d\t%5.2lf\t%s\t%5.2lf\t%5.2lf\t%5.2lf\n", njobs, mean_arrival_time, systemJobType?"n":"m", finishTime/njobs, scheduler->utilization, scheduler->qsize);   

    //    printf("%5.2lf & %5.2lf (%5.2lf) & %5.3lf & %5.5lf\n", mean_arrival_time, finishTime/njobs, scheduler->utilization, scheduler->qsize, MAX_JOBS/time);

    printf("%5.2lf & %5.2lf (%5.2lf) & %5.3lf %5.3lf %5.3lf %d %d\n", mean_arrival_time, finishTime/njobs, scheduler->utilization, scheduler->qsize, ((ProfitStrategy *)scheduler->strategy)->currentProfit, ((ProfitStrategy *)scheduler->strategy)->totalProfit, ((ProfitStrategy *)scheduler->strategy)->nrejected, scheduler->nfinished);   
}



