#include <stdio.h>
#include "hello.decl.h"

CProxy_main mainProxy;
CProxy_Hello arr;

class main : public Chare
{
	int nLeft;
public:
  main(CkMigrateMessage *m) {}
  main(CkArgMsg* m)
  {
    int nElements = 1;
    if (m->argc>1) nElements=atoi(m->argv[1]);
    delete m;
    nLeft=nElements;
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thishandle;

    arr = CProxy_Hello::ckNew();//nElements);
    for (int i=0;i<nElements;i++)
	    arr[i].insert();//1%CkNumPes());

    arr.runThread();
  };
  void done(void)
  {
	  nLeft--;
	  if (nLeft==0) {
		  CkPrintf("All done\n");
		  CkExit();
	  }
  };
};

CtvDeclare(Hello *,curHello);


extern int memory_checkfreq; //For memory-paranoid
void Hello_init(void) {
	CtvInitialize(Hello *,curHello);
	CtvAccess(curHello)=NULL;
	//memory_checkfreq=50;
}


class Hello : public ArrayElement1D
{
  enum {nData=2932}; //Bytes of stack data to check.
  void chk(char *data,bool write=false) {
	char cur=(char)0xcf;
	for (int i=0;i<nData;i++) {
		cur^=(char)((5<<(i%7))*(1<<((i/7)%7)));
		if (write) data[i]=cur;
		else 
		if (data[i]!=cur)
			CkAbort("Data corrupted during migration!");
	}
  }

  int five;//Always stores the constant 5
  double seven;
  char *heap; //Heap-allocated data

public:
  Hello()
  {
    CkPrintf("[%d] created\n",thisIndex);
    five=5;
    seven=7.0;
    heap=new char[nData];
    chk(heap,true);
  }

  Hello(CkMigrateMessage *m) {}
  ~Hello() {
    delete[] heap;
  }  

  void runThread(void)
  {
    int dis=thisIndex;
    CtvAccess(curHello)=this; //<- because "this" will change as we migrate
    int nMigrations=0;
    CkPrintf("[%d on %d] Starting thread\n",dis,CkMyPe());
    char stack[nData]; chk(stack,true);
    while (nMigrations<2000) {
	CkPrintf("[%d on %d] -- thread running --\n",dis,CkMyPe());
	CtvAccess(curHello)->startMig();
	chk(stack);
	nMigrations++;
    }
    mainProxy.done();
  }

  CthThread tid;
  void startMig(void) {
	CtvAccess(curHello)=NULL;
     	tid=CthSelf();
	arr[thisIndex].midMig();
	CkPrintf("[%d on %d] Suspending thread %p\n",thisIndex,CkMyPe(),tid);
	CthSuspend();
  }
  
  void midMig(void) {
	arr[thisIndex].endMig();
	int dest=(CkMyPe()+1)%CkNumPes();
	CkPrintf("[%d on %d] Leaving for %d\n",thisIndex,CkMyPe(),dest);
	migrateMe(dest);
  }
  void endMig(void) {
	CkPrintf("[%d on %d] Awakening thread %p\n",thisIndex,CkMyPe(),tid);
	CtvAccessOther(tid,curHello)=this;
	CthAwaken(tid);
  }
  
  void pup(PUP::er &p) {
	ArrayElement1D::pup(p);
	p(five); p(seven);
	if (five!=5) CkAbort("Integer corrupted during migrate!");
	if (seven!=7.0) CkAbort("Double corrupted during migrate!");
	if (!p.isUnpacking())
		CkPrintf("[%d on %d] Thread %p packing\n",thisIndex,CkMyPe(),tid);
	tid=CthPup((pup_er)&p,tid);
	if (p.isUnpacking()) {
		heap=new char[nData];
		CkPrintf("[%d on %d] Thread %p arriving\n",thisIndex,CkMyPe(),tid);
	}
	p(heap,nData);
	chk(heap);
  }

};

#include "hello.def.h"
