#include <stdio.h>
#ifndef WIN32
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#endif
#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;
/*readonly*/ int dieHow=3; //Determines method used to kill self

void die(void) {
  int x,y;
  double d=0.0;
  CkPrintf("\n\n\n");
  switch (dieHow) {
  case 0:
  	CkPrintf("About to call exit()\n");
  	exit(1); //Unexpected exit call
	break;
  case 1: //Unexpected abort
  	CkPrintf("About to abort\n");
  	CkAbort("death via abort");
  	break;
  case 2: //Write to NULL
  	CkPrintf("About to write to NULL (SIGSEGV)\n");
  	*(int *)NULL=0;
	break;
  case 3: //Read from NULL
  	CkPrintf("About to read from NULL (SIGSEGV)\n");
  	dieHow=*(int *)NULL; 
	break;
  case 4: //Divide by zero
  	CkPrintf("About to divide by zero (SIGFPE)\n");
  	y=0;
	x=1/y;
  	CkPrintf("Aw crap-- I survived SIGFPE!");
	break;
  case 5: //Unaligned access to double (not always a bus fault)
  	CkPrintf("About to access an unaligned double (SIGBUS)\n");
  	d=*(double *)(1+(char *)&d);
  	break;
  case 6: //Call random code (SIGILL)
  	{
	CkPrintf("About to execute some random crap (SIGILL)\n");
	const char crap[64]={
		0x0f,0x0a, /*A set of (for now!) illegal opcodes*/
		0x0f,0x25,
		0xf3,0x0f,0x13,
		0x00,0x00,0x00,0x00, /*Hopefully these will be illegal too*/
		0x00,0x00,0x00,0x00
	};
	typedef void (*fnPtr)(void);
	fnPtr crapPtr=(fnPtr)crap;
	(crapPtr)();
	}
	break;
#ifndef WIN32
  case 7: //Send SIGKILL to myself
	CkPrintf("About to send KILL to myself (SIGKILL)\n");
  	kill(getpid(),SIGKILL);
	break;
  case 8: //Send SIGQUIT to myself
	CkPrintf("About to send QUIT to myself (SIGQUIT)\n");
  	kill(getpid(),SIGQUIT);
	break;
#endif
  default:
  	CkAbort("Unrecognized death mode");
  };
  CkPrintf("Aw crap-- I survived death mode %d",dieHow);
  CkExit();
}

/*mainchare*/
class Main : public Chare
{
public:
  Main(CkArgMsg* m)
  {
    nElements=5;
    //Process command-line arguments
    if(m->argc >1 ) dieHow=atoi(m->argv[1]);
    delete m;
	
    //Start the computation
    mainProxy = thishandle;

    CProxy_Hello arr = CProxy_Hello::ckNew(nElements);
    arr.SayHi(17);
    
    if (dieHow<0) { //Die right here in main
    	dieHow=-dieHow;
    	die();
    }
  };

  void done(void)
  {
    CkPrintf("All done\n");
    CkExit();
  };
};

/*array [1D]*/
class Hello : public CBase_Hello 
{
public:
  Hello()
  {
  }

  Hello(CkMigrateMessage *m) {}
  
  void SayHi(int hiNo)
  {
    die();
  }
};

#include "hello.def.h"
