#include <string.h> // for strlen, and strcmp
#include <charm++.h>

#define NITER 1000

#include "pingpong.decl.h"

class PingMsg : public CMessage_PingMsg
{
  public:
    char x[100];
};

CProxy_main mainProxy;

class main : public Chare
{
  int phase;
  CkArrayID aid1;
  CkChareID cid;
  CkGroupID gid;
public:
  main(CkMigrateMessage *m) {}
  main(CkArgMsg* m)
  {
    delete m;
    if(CkNumPes()>2) {
      CkAbort("Run this program on 1 or 2 processors only.\n");
    }
    mainProxy = thishandle;
    phase = 0;
    gid = CProxy_PingG::ckNew();
    CProxy_PingC::ckNew(0);
    aid1 = CProxy_Ping1::ckNew(1);
    phase=0;
  };
  void chareCreated(CkChareID id) {
    cid=id;
    start();
  }

  double startTime;
  const char *testName;
  void start(void) {
    CkArrayIndex1D aidx1(0);
    PingMsg *savedMessage=new PingMsg;
    startTime=CkWallTimer();
    int i;
    switch(phase) {
      case 0:
	testName="CkSendMsg";
	for (i=0;i<NITER;i++)
	  CkSendMsg(CkIndex_PingC::recv(NULL),new PingMsg,&cid);
	break;
      case 1:
	testName="CkSendMsgInline";
	for (i=0;i<NITER;i++)
	  CkSendMsgInline(CkIndex_PingC::recv(NULL),new PingMsg,&cid);
        break;
      case 2:
	testName="CkSendMsgInline (re-use)";
	for (i=0;i<NITER;i++)
	  CkSendMsgInline(CkIndex_PingC::recvNoDelete(NULL),savedMessage,&cid);
        break;
      case 3:
	testName="CkSendMsgBranch";
	for (i=0;i<NITER;i++)
	  CkSendMsgBranch(CkIndex_PingG::recv(NULL),new PingMsg,0,gid);
	break;
      case 4:
	testName="CkSendMsgBranchInline";
	for (i=0;i<NITER;i++)
	  CkSendMsgBranchInline(CkIndex_PingG::recv(NULL),new PingMsg,0,gid);
        break;
      case 5:
	testName="CkSendMsgBranchInline (re-use)";
	for (i=0;i<NITER;i++)
	  CkSendMsgBranchInline(CkIndex_PingG::recvNoDelete(NULL),savedMessage,0,gid);
        break;
      case 6:
	testName="CkSendMsgArray";
	for (i=0;i<NITER;i++)
	  CkSendMsgArray(CkIndex_Ping1::recv(NULL),new PingMsg,aid1,aidx1);
	break;
      case 7:
	testName="CkSendMsgArrayInline";
	for (i=0;i<NITER;i++)
	  CkSendMsgArrayInline(CkIndex_Ping1::recv(NULL),new PingMsg,aid1,aidx1);
        break;
      case 8:
	testName="CkSendMsgArrayInline (re-use)";
	for (i=0;i<NITER;i++)
	  CkSendMsgArrayInline(CkIndex_Ping1::recvNoDelete(NULL),savedMessage,aid1,aidx1);
        break;

      default:
        CkExit();
    }    
  }

  void done(void)
  {
    double elapsed=CkWallTimer()-startTime;
    CmiPrintf("One-way %s: %.3f us\n",testName,1.0e6*elapsed/NITER);
    phase++;
    start();
  };
};

class itCounter {
  int n;
public:
  itCounter() {n=0;}
  void inc(void) {
    n++;
    if (n==NITER) {
      mainProxy.done();
      n=0;
    }    
  }
};

class PingG : public Group
{
  itCounter it;
public:
  PingG() {}
  PingG(CkMigrateMessage *m) {}
  void recv(PingMsg *m) {it.inc(); delete m;}
  void recvNoDelete(PingMsg *m) {it.inc();}
};

class Ping1 : public ArrayElement1D
{
  itCounter it;
public:
  Ping1() {}
  Ping1(CkMigrateMessage *m) {}
  void recv(PingMsg *m) {it.inc(); delete m;}
  void recvNoDelete(PingMsg *m) {it.inc();}
};

class PingC : public Chare
{
  itCounter it;
 public:
  PingC(void) {
    mainProxy.chareCreated(thishandle);
  }
  PingC(CkMigrateMessage *m) {}
  void recv(PingMsg *m) {it.inc(); delete m;}
  void recvNoDelete(PingMsg *m) {it.inc();}
};
#include "pingpong.def.h"
