#include "mblock.h"
#include "mpi.h"
#include <stdio.h>

extern "C" void init(void)
{
	MBLK_Init(MPI_COMM_WORLD);
	
	MBLK_Print("Reading parameter file");
	FILE *f=fopen("poisson.key","r");
	if (!f) MBLK_Print("Could not open poisson.key!\n");
	char prefix[120];
	fscanf(f,"%s",prefix);
	MBLK_Read(prefix,3);
}

extern "C" void BC_imposed(double *grid,int dims[3],int start[3],int end[3])
{
  int err; // Return value
  int i,j,k;
  int si,sj,sk, ei,ej,ek; // My interior region
  int ghostWidth=1;

  si=ghostWidth+start[0]; sj=ghostWidth+start[1]; sk=ghostWidth+start[2]; 
  ei=ghostWidth+end[0];   ej=ghostWidth+end[1];   ek=ghostWidth+end[2]; 

  for (int k=sk;k<ek;k++)  
  for (int j=sj;j<ej;j++)
  for (int i=si;i<ei;i++)	  
	  grid[i+dims[0]*(j+dims[1]*k)]=1.0;
}

extern "C" void driver(void)
{
	init();
	
	int blockNo;
	int i,j,k,c[3];
	int size[3],ni,nj,nk;
	int si,sj,sk, ei,ej,ek;
	double *grid, *newGrid;
	double *nodelocs;
	int tStep,nSteps,fid;
	int ghostWidth=1;

	double w, cenWeight,neighWeight, total,sum;
	int nSum;

// Read parameters
  nSteps=10; // hardcoded sim. length (should come from parameter file)
  w=2.0-0.1; // SOR parameter
  cenWeight=1.0-w;
  neighWeight=0.25*w;

// Allocate and initialize grid
  MBLK_Get_myblock(&blockNo);
  MBLK_Get_blocksize(size);
  CmiPrintf("Entered driver %dx%dx%d\n",size[0],size[1],size[2]);
  
  int nodedim[3];
  int nodedimsize=1;
  for (i=0;i<3;i++) {
    nodedim[i]=size[i]+1;
    nodedimsize*=nodedim[i];
  }
  nodelocs=new double[3*nodedimsize];
  MBLK_Get_nodelocs(nodedim,nodelocs);

  ni=size[0]+2*ghostWidth; 
  nj=size[1]+2*ghostWidth; 
  nk=size[2]+2*ghostWidth;
  si=ghostWidth; sj=ghostWidth; sk=ghostWidth;
  ei=si+size[0];   ej=sj+size[1];   ek=sk+size[2]; 
  
  grid=new double[ni*nj*nk];
  newGrid=new double[ni*nj*nk];  
  
  size[0]=ni; size[1]=nj; size[2]=nk;
  MBLK_Create_field(
       size,1, MBLK_DOUBLE,1,
       sizeof(double)*(si+ni*(sj+nj*sk)),
       sizeof(double),&fid);

// Register boundary condition functions
  MBLK_Register_bc(0,ghostWidth,(MBLK_BcFn)BC_imposed);

  MBLK_Print("Beginning time loop");
  for (tStep=1;tStep<=nSteps;tStep++) 
  {
     MBLK_Apply_bc_all(grid,size);

     MBLK_Update_field(fid,ghostWidth,grid);

     for (int k=sk;k<ek;k++)  
     for (int j=sj;j<ej;j++)
     for (int i=si;i<ei;i++) {
	     double *c=&grid[i+ni*(j+nj*k)];
             // Only relax along I and J directions-- not K
	     newGrid[i+ni*(j+nj*k)]=
		     cenWeight*c[0]+
		     neighWeight*(c[-1]+c[1]+c[-ni]+c[ni]);
     }

// Copy the new grid back onto the old one using a pointer flip
     double *tmp=grid; grid=newGrid; newGrid=tmp;
  }

  MBLK_Print("Done with driver");
}

