!-------------------------------------------------------------------------------
!  Description : Write out a .msh file
!  Creation : Orion Sky Lawlor, olawlor@acm.org, 6/13/2001
!             added iblock, JB 07/01/2002
!-------------------------------------------------------------------------------
     SUBROUTINE WRITE_MSH(iblock,ni,nj,nk,x,y,z,F_name)

      IMPLICIT NONE
      DOUBLE PRECISION :: total_time
      INTEGER :: iblock,ni,nj,nk
      DOUBLE PRECISION :: x(ni,nj,nk),y(ni,nj,nk),z(ni,nj,nk)
      INTEGER :: i,j,k
      CHARACTER (LEN=500) :: F_name,filnam
      INTEGER :: F_ifumsh = 14
      
      WRITE(filnam,11)F_name(1:INDEX(F_name,' ')-1)
!      WRITE(*,*)'Fortran says block',filnam,'bounds are:', &
!           minval(x),maxval(x),minval(y),maxval(y),minval(z),maxval(z)

      OPEN (F_ifumsh,file=filnam,form='unformatted')

      total_time=0.0
      WRITE(F_ifumsh)total_time
      WRITE(F_ifumsh)ni,nj,nk
      WRITE(F_ifumsh)(((x(i,j,k),y(i,j,k),z(i,j,k), &
                         i=1,ni),j=1,nj),k=1,nk)

      CLOSE(F_ifumsh)

11     FORMAT(a)

      END SUBROUTINE





