/*
Reads a proprietary .reg input file, a simple ASCII format, 
and passes it to a blockConsumer.  Returns an 
error string on errors; returns NULL on sucess.

Orion Sky Lawlor, olawlor@acm.org, 4/29/2002
*/
#include <stdio.h>
#include "gridutil.h"

const char *read_reg(const char *regFile,blockConsumer &dest)
{
	//Open the input file
	FILE *in=fopen(regFile,"r");
	if (in==NULL) return "Couldn't open input .reg file";

	//Read the block size
	int dimArr[3];
	vector3d min,max;
	for (int axis=0;axis<3;axis++)
	{
		double m;
		if (1!=fscanf(in,"%d",&dimArr[axis]))
			return "Couldn't read block dimension";	
		if (1!=fscanf(in,"%lf",&m)) return "Couldn't read block min";
		min[axis]=m;
		if (1!=fscanf(in,"%lf",&m)) return "Couldn't read block max";
		max[axis]=m;
	}
	fclose(in);

	//Allocate return grid
	blockDim dim(dimArr[0],dimArr[1],dimArr[2]);
	vector3d *locs=dest.allocateBlock(dim);
	
	//Fill in the grid
	blockLoc i;
	blockSpan s(blockLoc(0,0,0),dim);
	BLOCKSPAN_FOR(i,s) {
		vector3d v;
		for (int axis=0;axis<3;axis++) {
			double scl=i[axis]/(float)(dim[axis]-1);
			v[axis]=min[axis]+scl*(max[axis]-min[axis]);
		}
		locs[dim[i]]=v;
	}
	
	dest.consume(dim,locs);	
	dest.freeBlock(locs);

	return NULL; //Everything worked
}
