#include "converse.h"
#include "pgm.h"

CkChareID mainhandle;
int slices;
int numChares;
int numSamples;

main::main(CkArgMsg * m)
{ 
  int i, low = 0;

  if(m->argc < 3) CmiAbort("./pgm numSamples numChares.");
  numSamples = atoi(m->argv[1]);    // readonly initialization
  numChares = atoi(m->argv[2]);

  for (i=0; i<numChares; i++) {
    CProxy_piPart::ckNew();
  }
  responders = numChares;
  count = 0;
  mainhandle = thishandle; // readonly initialization
}

void main::results(DataMsg *msg) 
{ 
  count += msg->count;
  if (0 == --responders) {
    CkPrintf("pi=: %f \n", 4.0*count/numSamples);
    CkExit();
  }
}

piPart::piPart()
{ 
  int i;
  int mySamples,localCount=0;
  double x,y;

  CrnSrand((int) this);

  mySamples = numSamples/numChares;
  for (i= 0; i<= mySamples; i++) {
    x = CrnDrand();
    y = CrnDrand();
    if ((x*x + y*y) <= 1.0) localCount++;
  }

  DataMsg *result = new DataMsg;
  result->count = localCount;
  CProxy_main mainproxy(mainhandle);
  mainproxy.results(result);

  delete this;
}

#include "pgm.def.h"
