#include <stdio.h>
#include "liveViz3d.h"
#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;

/*mainchare*/
class Main : public Chare
{
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=5;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thishandle;

    CProxy_Viewables arr = CProxy_Viewables::ckNew(nElements);

    //Broadcast to "LiveVizRequest" when a liveViz request comes in.
    CkBbox3d box; box.empty(); //FIXME: find 3d bounding box
    box.add(CkVector3d(0,0,0));
    box.add(CkVector3d(1,1,1));
    liveViz3dInit(box,CkCallback(CkIndex_Viewables::LiveVizRequest(0),arr));
  };

  void done(void)
  {
    CkPrintf("All done\n");
    CkExit();
  };
};

/**
 * A pointViewer is a trivial little viewer for a cloud of points.
 * Because it draws all points as a single pixel, it's not 
 * resolution-independent, and hence looks pretty bad.
 */
class pointViewer : public CkInterestViewable {
        int nPts;
	CkVec<CkVector3d> pts;
public:
	pointViewer(const CkVec<CkVector3d> &pts_,const CkViewableID &id_);
	
	void render(const CkViewpoint &vp,CkImage &dest);
};


pointViewer::pointViewer(const CkVec<CkVector3d> &pts_,const CkViewableID &id_)
	:nPts(pts_.size()), pts(pts_)
{
	//Find the point bounding box, and set the corners as 
	// interest points:
	CkBbox3d box; box.empty();
	for (int i=0;i<nPts;i++) box.add(pts[i]);
	setUnivPoints(CkInterestSet(box));
	setViewableID(id_);
}

static unsigned char *clipArr=CkImage::newClip();
void pointViewer::render(const CkViewpoint &vp,CkImage &dest)
{
	dest.clear();
	const unsigned char src[4]={255,255,255,255};
	CkRect r(dest.getRect());
	
	for (int i=0;i<nPts;i++) {
		CkVector3d p(pts[i]);
		CkVector3d s(vp.project_noz(p));
		int sx=(int)s.x, sy=(int)s.y;
		if (r.inbounds(sx,sy))
			dest.addPixelClip(src,dest.getPixel(sx,sy),clipArr);
		else
			CkPrintf("Skipping out-of-bounds point(!)\n");
	}
	CkPrintf("Generated (%dx%d) view\n",dest.getWidth(),dest.getHeight());
}

double randomValue(void) {
	return (rand()%0x10000)*(1.0/(float)(0x10000));
}
double map(int axis,double m) {
	return pow(m,axis+1);
}

/*array [1D]*/
class Viewables : public CBase_Viewables
{
  pointViewer *p;
public:
  Viewables(void)
  {
    double fracWidth=1.0/nElements;
    double startFrac=thisIndex*fracWidth;
    CkVec<CkVector3d> pts;
    /// Add some random points
    int n=100000/nElements;
    for (int i=0;i<n;i++)
      pts.push_back(CkVector3d(map(0,randomValue()),map(1,randomValue()),
      	map(2,startFrac+fracWidth*randomValue())));
    // pts.push_back(CkVector3d(0.5,0.5,0.5));
    CkViewableID id(1,&thisIndex);
    p=new pointViewer(pts,id);
    CkPrintf("Hello %d created\n",thisIndex);
  }

  Viewables(CkMigrateMessage *m) {}
  
  void LiveVizRequest(liveViz3dRequestMsg *m)
  {
    liveViz3dHandleRequest(m,*p);
  }
};

#include "hello.def.h"
