#include <stdio.h>
#include "liveViz3d.h"
#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;

/*mainchare*/
class Main : public Chare
{
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=5;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thishandle;

    CProxy_Viewables arr = CProxy_Viewables::ckNew(nElements);

    //Broadcast to "LiveVizRequest" when a liveViz request comes in.
    CkBbox3d box; box.empty(); //FIXME: find 3d bounding box
    box.add(CkVector3d(0,0,0));
    box.add(CkVector3d(1,1,1));
    liveViz3dInit(box,CkCallback(CkIndex_Viewables::LiveVizRequest(0),arr));
  };

  void done(void)
  {
    CkPrintf("All done\n");
    CkExit();
  };
};

int createCount;
CkView *makeCheckerboard(const unsigned char *color, int size, 
	const CkVector3d &origin, const CkVector3d &xAxis, const CkVector3d &yAxis) 
{
    int w=size, h=size;
    CkAllocView *v=new CkAllocView(w,h);
    v->id=CkViewableID(1,&createCount); createCount++;
    v->style.corners[0]=origin;
    v->style.corners[1]=origin+xAxis;
    v->style.corners[2]=origin+yAxis;
    v->style.corners[3]=origin+xAxis+yAxis;
    
    CkImage &dest=v->getImage();
    const unsigned char white[4]={255,255,255,255};
    for (int y=0;y<dest.getHeight();y++)
    for (int x=0;x<dest.getWidth();x++) {
        bool copyWhite=(x+y)%2;
	if (x<2) copyWhite=false;
	if (y<2) copyWhite=true;
        dest.copyPixel(copyWhite?white:color,dest.getPixel(x,y));
    }
    
    return v;
}


/*array [1D]*/
class Viewables : public CBase_Viewables
{
  CkFixedViewable *x, *y, *z;
public:
  Viewables(void)
  {
    const unsigned char trans=100;
    const unsigned char red[4]={trans,0,0,trans};
    const unsigned char green[4]={0,trans,0,trans};
    const unsigned char blue[4]={0,0,trans,trans};
    CkView *Xplane=makeCheckerboard(red,16,
    	CkVector3d(0,0,0),CkVector3d(0,1,0),CkVector3d(0,0,1));
    CkView *Yplane=makeCheckerboard(green,32,
    	CkVector3d(0,0,0),CkVector3d(1,0,0),CkVector3d(0,0,1));
    CkView *Zplane=makeCheckerboard(blue,64,
    	CkVector3d(0,0,0),CkVector3d(1,0,0),CkVector3d(0,1,0));
    
    x=new CkFixedViewable(Xplane); Xplane->unref();
    y=new CkFixedViewable(Yplane); Yplane->unref();
    z=new CkFixedViewable(Zplane); Zplane->unref();
    
    CkPrintf("Hello %d created\n",thisIndex);
  }

  Viewables(CkMigrateMessage *m) {}
  
  void LiveVizRequest(liveViz3dRequestMsg *m)
  {
    liveViz3dHandleRequest(m,*x); 
    liveViz3dHandleRequest(m,*y); 
    liveViz3dHandleRequest(m,*z); 
    delete m;
  }
};

#include "hello.def.h"
