#include "converse.h"
#include "ccs-client.c"

/* Write a big-endian 4-byte int to this char array. */
void writeInt(unsigned char *dest,int v) {
	dest[0]=(unsigned char)(v>>24);
	dest[1]=(unsigned char)(v>>16);
	dest[2]=(unsigned char)(v>>8);
	dest[3]=(unsigned char)(v>>0);
}

/*
 Request a new liveViz image of this size from
 this server.
*/
void doTest(CcsServer *svr,int wid,int ht) {
	double startTime=CmiWallTimer();
	const int reqLen=4*4;
	unsigned char req[reqLen];
	writeInt(&req[4*0],1); /* Client version */
	writeInt(&req[4*1],1); /* Request type */
	writeInt(&req[4*2],wid); writeInt(&req[4*3],ht);
	CcsSendRequest(svr,"lvImage",0, reqLen,(char *)req);
	// CmiPrintf("Client: request sent: %.6f s\n",CmiWallTimer()-startTime);
	
	void *img; int imgLen=0;
	CcsRecvResponseMsg(svr, &imgLen,&img, 60);
	free(img);
	CmiPrintf("Client: total request time for %d %d image (%d bytes): %.6f s\n",
		wid,ht, imgLen, CmiWallTimer()-startTime);
}

extern "C" void myMain(int argc,char **argv) {
	CcsServer svr;
	if (argc!=4) { 
		CmiPrintf("Usage: client <host> <port> <image size>\n");
		exit(1);
	}
	const char *host=argv[1];
	int port=atoi(argv[2]);
	int imgSize=atoi(argv[3]);
	CcsConnect(&svr, host, port, NULL);
	
	// doTest(&svr, imgSize/2, imgSize/2);
	doTest(&svr, imgSize, imgSize);
	// doTest(&svr, imgSize*2, imgSize*2);
	
	CcsFinalize(&svr);
}


int main(int argc,char **argv) {
	ConverseInit(argc,argv,myMain,1,0);
	return 0;
}

