#include "test.h"

// implementation of the startup function
extern "C" void armciStart(int argc,char **argv) {
  void **ptrs;
  int *myBaseIntAddress;
  int *targetBaseIntAddress;

  ARMCI_Init();
  ptrs = new (void *)[armci_nproc];

  // we want 500 bytes each
  ARMCI_Malloc(ptrs, 500);
  /*
  for (int i=0; i<armci_nproc; i++) {
    ckout << "At " << armci_me << "- virtual pe " << i << ": " << ptrs[i] << endl;
  }
  */

  // write an int into own memory and send it to another second of someone
  // else's memory.
  myBaseIntAddress = (int *)ptrs[armci_me];
  *myBaseIntAddress = armci_me;

  // put to right neighbor
  targetBaseIntAddress = (int *)ptrs[(armci_me+1)%armci_nproc];
  ARMCI_Put((void *)myBaseIntAddress, (void *)(targetBaseIntAddress + 1),
	    sizeof(int), (armci_me+1)%armci_nproc);

  // need barrier to make sure everyone has managed to do a put
  TCHARM_Barrier();

  // get from right neighbor
  targetBaseIntAddress = (int *)ptrs[(armci_me+1)%armci_nproc];
  ARMCI_Get((void *)targetBaseIntAddress, (void *)(myBaseIntAddress+2),
	    sizeof(int), (armci_me+1)%armci_nproc);

  // print the resulting values in memory.
  ckout << armci_me << " has value = " << *myBaseIntAddress 
	<< " | my left neighbor gave me " << *(myBaseIntAddress+1) 
	<< " | I got " << *(myBaseIntAddress+2) << " from my right neighbor"
	<< endl;
  TCHARM_Barrier();

  ARMCI_Free(ptrs[armci_me]);

  ARMCI_Finalize();
}

