#include <ampi.h>
#include <charm++.h>

int 
main(int argc, char** argv)
{
  int i, size, rank;
  int *winArea, *rcvvals;
  MPI_Win win;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);
  MPI_Alloc_mem(size * sizeof(int), MPI_INFO_NULL, &rcvvals);
  MPI_Win_create((void*)winArea, sizeof(int), sizeof(int), MPI_INFO_NULL,
		 MPI_COMM_WORLD, &win);
  *winArea = rank;
  MPI_Win_fence(0, win);

  // Set all the target areas to be -1 
  for(i = 0; i<size; i++){
    rcvvals[i] = -1;
    MPI_Get(&rcvvals[i], 1, MPI_INT, i, 0, 1, MPI_INT, win);
  }

  MPI_Win_fence(0, win);


  CkPrintf("Rank %d Get values: [", rank);
  for(i =0; i<size; i++){
      CkPrintf(" %d ",rcvvals[i]);
  }
  CkPrintf("]\n");

  MPI_Win_free(&win);  
  MPI_Free_mem(winArea);
  MPI_Free_mem(rcvvals);
  MPI_Finalize();
  return(0);
}

