#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>
#include "charm.h"
#include "tcharmc.h"

int myRank;

int main(int argc,char **argv)
{
	MPI_Init(&argc,&argv);
	double inval,outval;
	int rank,size;
	MPI_Comm_rank(MPI_COMM_WORLD, &rank);
	MPI_Comm_size(MPI_COMM_WORLD, &size);
	
	myRank=rank;
	printf("[%d] before MyRank=%d (at %p)\n",rank,myRank,&myRank);
	
	for (int i=0;i<10;i++) {
	  MPI_Barrier(MPI_COMM_WORLD);
	  printf("[%d] after MyRank=%d (at %p) pe=%d\n",rank,myRank,&myRank,CmiMyPe());
	  if (myRank!=rank) {
		printf("[%d] Global variable not preserved! (%d)\n",rank,myRank);
		abort();
	  }
	  TCHARM_Migrate_to((CmiMyPe()+1)%CmiNumPes());
	}
	
	MPI_Finalize();
	return 0;
}
