// File: event.h
// Defines: Event and Spawned Event
// Last Modified: 06.04.01 by Terry L. Wilmarth

#ifndef EVENT_H
#define EVENT_H

extern int assert(int);
#include "envelope.h"

// List to store records of events spawned by a certain event; maintained in
// the eventQueue entry for an event
class SpawnedEvent {
 public:
  int objIdx, timestamp;  // array index of the object the event was sent to
                          // and timestamp of the event
  eventID evID;           // the event ID of the sent event
  SpawnedEvent *next;
  SpawnedEvent();         // initializing constructor
  SpawnedEvent(int idx, eventID e, int ts, SpawnedEvent *n); // set constructor
  ~SpawnedEvent() { }
  void pup(PUP::er &p) { p(objIdx); p(timestamp); evID.pup(p); } // pup one
};

// Event holds all info about an event in eventQueue
class Event {
 public:
  eventID evID;   // the event's unique global ID
  int fnIdx,      // the function index associated with the event
    timestamp,    // the timestamp of this event
    done,         // event execution status: 0=not done, 1=done, 2=executing
    commitBfrLen; // length of commitBfr
  int  commitErr; // flag indicating commit error
  char *commitBfr;// buffered I/O generated by the event
  eventMsg *msg;  // the message corresponding to the event
  SpawnedEvent *spawnedList;  // list of events spawned by this event
  rep *cpData;    // checkpointed data
  Event *next, *prev;
  Event();        // basic initializing constructor
  ~Event();       // basic destructor
  void pup(PUP::er &p);  // pup entire event
};

#endif
