#include "blue.h"
#include "blue_impl.h"
#include "blue_logs.h"
#include "trace-projections.h"

#define  yourUniqueTaskIDtype TaskID*
#define factor (1e9)

class TaskID{
 public:
  int srcNode;
  int msgID;
  int index;
  TaskID(){srcNode = -100; msgID=-100;index=-100;}
  TaskID(int s, int m, int i){
    srcNode = s;
    msgID = m;
    index = i;
  }
  TaskID(TaskID *other){
    srcNode = other->srcNode;
    msgID = other->msgID;
    index = other->index;
  }
  int operator==(const TaskID other){
    //   printf("== called with my:(s:%d m:%d i:%d) and other:(s:%d m:%d i:%d) \n",srcNode,msgID,index,other.srcNode,other.msgID,other.index);
    if(srcNode ==-1 && msgID == -1)
      return (index == other.index);
    else
      return ((srcNode==other.srcNode)&&(msgID==other.msgID));
  }
  void operator=(const TaskID other){
    srcNode = other.srcNode;
    msgID = other.msgID;
    index = other.index;
  }
  void pup(PUP::er &p){
    p|srcNode; p|msgID; p|index;
  }
}; 


class BGprocMsg {
 public:
  int nodePID;
 public:
  BGprocMsg(int node) : nodePID(node) {}
  // insert all log data for a BG processor here
  BGprocMsg& operator=(const BGprocMsg& obj) {
    eventMsg::operator=(obj);
    // must provide assignment operator for POSE message classes
    return *this;
  }
};

class BGnodeMsg {
 public:
  int nodeIdx, procsPerNode, switchID;
 public:
  BGnodeMsg(int nodeid, int nwth, int switchid): nodeIdx(nodeid), procsPerNode(nwth), switchID(switchid)  {}
  BGnodeMsg& operator=(const BGnodeMsg& obj) {
    eventMsg::operator=(obj);
    return *this;
  }
};


class TaskMsg {
 public:

  TaskID taskID;
  int destNode;
  int destNodeCode;
  int desttID;   //dest threadID
  int receiveTime;
  int msgsize;
  
  TaskMsg(){destNode=desttID=-1;receiveTime=0;msgsize=0;taskID.srcNode=taskID.msgID=taskID.index=-1;}
  TaskMsg(int s, int m, int i){
    taskID.srcNode=s;
    taskID.msgID=m;
    taskID.index=i;
    destNode = -1;
    desttID = -1;
    receiveTime = msgsize = 0;
  }
  TaskMsg(int s, int m, int i, int rt, int ms, int dn, int dnc, int dt){
    taskID.srcNode=s;
    taskID.msgID=m;
    taskID.index=i;
    receiveTime = rt;
    msgsize = ms;
    destNode = dn;
    destNodeCode = dnc;
    desttID = dt;
  }
  TaskMsg(TaskID& t, int rt, int ms, int dn, int dnc, int dt){
    taskID.srcNode=t.srcNode;
    taskID.msgID=t.msgID;
    taskID.index=t.index;
    receiveTime = rt;
    msgsize = ms;
    destNode = dn;
    destNodeCode = dnc;
    desttID = dt;
  }
  TaskMsg& operator=(const TaskMsg& obj) {
    eventMsg::operator=(obj);
    taskID = obj.taskID;
    destNode = obj.destNode;
    desttID = obj.desttID;
    receiveTime = obj.receiveTime;
    msgsize = obj.msgsize;
    return *this;
  }
  
  TaskID getTaskID (){
    return taskID;
  }
  int isNull(){return ((destNode==-1)&&(desttID==-1)&&(receiveTime==0));}
  int getDestNode() {return destNode;}  
  void pup(PUP::er &p){
    taskID.pup(p);
    p|destNode;p|destNodeCode;p|desttID;p|receiveTime;p|msgsize;
  }
  
};


class Task
{
  //implement a taskList type to store a list of generated tasks
  // datafields: 
 private:
  int convertToInt(double inp);
  struct ProjEvent {
    int index;
    int startTime;
    void pup(PUP::er &p) { p|index; p|startTime; }
  };
  struct bgPrintEvent {
    char* data;
    int sTime;
    void pup(PUP::er &p) { p|sTime;
   			   int slen = 0;
	                   if (p.isPacking()) slen = strlen((char *)data)+1;
	                   p|slen;
	                   if (p.isUnpacking()) data=(char *)malloc(sizeof(char)*slen);
	                   p((char *)data,slen); }
  };  
 public:
  TaskID taskID;
  int receiveTime, execTime, startTime, newStartTime;
  char name[20];
  TaskID* backwardDeps;
  TaskID* forwardDeps;
  TaskMsg* taskmsgs;
  ProjEvent* projevts;
  bgPrintEvent* printevts;
  int printevtLen, projevtLen;
  int bDepsLen, fDepsLen,taskMsgsLen;
  int done;
  void convertFrom(bgTimeLog*, int index, int numWth);
  // implement these events
  int getRecvTime(){return receiveTime;}
  yourUniqueTaskIDtype getTaskID();
  void pup(PUP::er &p);
};


class BGproc {

 private:
  int numX,numY,numZ,numCth,numWth,numPes,totalProcs,procNum;
  int nodePID;		// node pose ID it belongs to
  Task* taskList;
  int numTasks;
  int *done;

  LogEntry  *logs;
  int numLogs;
  FILE *proj;
  int binary;

  int isValid(bgTimeLog*);
  int locateTask(TaskID* taskID);
  inline int locateTask(TaskID &taskID)
		{ return locateTask(&taskID); }
  void markTask(TaskID* taskID);

 public:
  BGproc();
  BGproc(BGprocMsg *m); 
  ~BGproc();
  inline BGproc& operator=(const BGproc& obj) 
	{ rep::operator=(obj); 
	  // one need to store done array, others are const
	  numTasks = obj.numTasks;
          if (!done) done = new int[numTasks];
	  for (int i=0; i<numTasks; i++) done[i] = obj.done[i];
	  return *this; }
  void pup(PUP::er &p);
//  void cpPup(PUP::er &p) { }
  // Event methods
  void executeTask(TaskMsg *m);
  void executeTask_anti(TaskMsg *m);
  void executeTask_commit(TaskMsg *m);
  //local methods (maybe make private)
  void updateReceiveTime(TaskMsg* m);
  int dependenciesMet(yourUniqueTaskIDtype taskID);
  void updateStartTime(yourUniqueTaskIDtype taskID, int newTime);
  void addAsDependent(yourUniqueTaskIDtype taskID); 
  void enableGenTasks(TaskID* taskID,int oldStartTime, int newStartTime);
  void SendMessage(TaskMsg *inMsg, int myNode, int srcSwitch,
		   int destNodeCode, int destTID, int taskOffset);
  void GeneralSend(TaskMsg *inMsg, int myNode, int srcSwitch, 
		  int destSwitch, int destNodeCode, int destTID, int destNode, 
		  int taskOffset);
  void DirectSend(TaskMsg *inMsg, int myNode, int srcSwitch,
	       int destSwitch, int destNodeCode, int destTID, int destNode, 
	       int taskOffset);
  void NetSend(TaskMsg *inMsg, int myNode, int srcSwitch,
	       int destSwitch, int destNodeCode, int destTID, int destNode, 
	       int taskOffset);
  void enableDependents(yourUniqueTaskIDtype taskID);
  TaskMsg* getGeneratedTasks(yourUniqueTaskIDtype taskID);
  int getNumGeneratedTasks(yourUniqueTaskIDtype taskID);
  int getDuration(yourUniqueTaskIDtype taskID);
  int getDuration(TaskID taskID);
  int getReceiveTime(TaskID taskID);
  int getStartTime(yourUniqueTaskIDtype taskID);
  void terminus();
};

class BGnode {
 private:
  int nodePID;		// index to pose
  int myNodeIndex;	// index in node array
  int firstProcPID;	// first BGproc
  int procsPerNode; 
  int switchPID;	// swiytch PID
 public:
  BGnode();
  BGnode(BGnodeMsg *);
  ~BGnode();
  void pup(PUP::er &p);
  void cpPup(PUP::er &p) { }
  inline BGnode& operator=(const BGnode& obj) 
	{ rep::operator=(obj); return *this; }
  // Event methods
  void recvOutgoingMsg(TaskMsg *rm);
  inline void recvOutgoingMsg_anti(TaskMsg *m)  {}
  inline void recvOutgoingMsg_commit(TaskMsg *m)  {}
  void recvIncomingMsg(TaskMsg *rm);
  inline void recvIncomingMsg_anti(TaskMsg *rm) {}
  inline void recvIncomingMsg_commit(TaskMsg *rm)  {}
};

