#include <stdio.h>
#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;

/*mainchare*/
class Main : public CBase_Main
{
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=1;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thishandle;

    CProxy_Hello arr = CProxy_Hello::ckNew(nElements);

    for (int i=0;i<nElements;i++)
      arr[i].SayHi(17);
    // arr[0].SayHi(19);
    CkStartQD(CkCallback(index_t::done(),thisProxy));
  };

  void done(void)
  {
    CkPrintf("All done\n");
    CkExit();
  };
};

class fooMsg : public CMessage_fooMsg {
public:
	int prio;
	int queueing;
};

/*array [1D]*/
class Hello : public CBase_Hello 
{
  /*
    Send a prioritized message with the given queueing
    and (bitvector or integer) priority to yourself.
  */
  void sendPrio(int queueing,int prio) {
        int priobits=8*sizeof(int);
        fooMsg *pmsg = new(priobits) fooMsg();
        *(int *)CkPriorityPtr(pmsg) = prio;
        CkSetQueueing(pmsg, queueing);
	// Save the priority and queueing for the printf:
	pmsg->prio=prio;
	pmsg->queueing=queueing;
        thisProxy[thisIndex].pt(pmsg);
  }
  void sendPrio(int queueing) {
        sendPrio(queueing,-0x80000000);
        sendPrio(queueing,-0x7fFFffFF);
        sendPrio(queueing,-0x40000000);
        sendPrio(queueing,-2);
        sendPrio(queueing,-1);
        sendPrio(queueing,0);
        sendPrio(queueing,1);
        sendPrio(queueing,2);
        sendPrio(queueing,0x40000000);
        sendPrio(queueing,0x7fFFffFF);
  }
public:
  Hello()
  {
    CkPrintf("Hello %d created\n",thisIndex);
  }

  Hello(CkMigrateMessage *m) {}
  
  void SayHi(int hiNo)
  {
    CkPrintf("Hi[%d] from element %d\n",hiNo,thisIndex);
    thisProxy[thisIndex].rt();
    sendPrio(CK_QUEUEING_IFIFO);
    sendPrio(CK_QUEUEING_BFIFO);
  }
  void pt(fooMsg *m) {
    if (m->queueing==CK_QUEUEING_IFIFO) 
      CkPrintf("[%d] Integer %d ( => 0x%08x)\n",thisIndex,m->prio,
      	(unsigned int)(m->prio+0x80000000u));
    else if (m->queueing==CK_QUEUEING_BFIFO) 
      CkPrintf("[%d] Bitvector 0x%08x\n",thisIndex,m->prio);
    else
      CkAbort("Unrecognized fooMsg::queueing!");
  }
  void rt(void) {
    CkPrintf("[%d] Regular message\n",thisIndex);
  }
};

#include "hello.def.h"
