#include <stdio.h>
#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int nElements;

/*mainchare*/
class Main : public Chare
{
	CProxy_Hello arr;
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=5;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;

    //Start the computation
    mainProxy = thishandle;

    arr = CProxy_Hello::ckNew(nElements);

    arr.stageOne();
  };

  void bottleneck(CkReductionMsg *m) {
	  delete m;
	  arr.stageFour();
  }

  void done(CkReductionMsg *m)
  {
    if (m->getUserFlag()!=39) CkAbort("Bad userFlag during main::done");
    delete m;
    CkPrintf("All done\n");
    CkExit();
  };
};

/*array [1D]*/
class Hello : public CBase_Hello 
{
	int stage;
	void checkStage(int shouldBe) {
		if (++stage!=shouldBe)
			CkAbort("Reached unexpected stage number!");
		CkPrintf("%d at stage %d\n",thisIndex,shouldBe);
	}
	CthThread suspendedthread;
public:
  Hello()
  {
    CkPrintf("Hello %d created\n",thisIndex);
    stage=0;
  }

  Hello(CkMigrateMessage *m) {}
  
  void stageOne(void) {
	  checkStage(1);
	  //When the reduction is done, it'll broadcast our stage two:
	  CkCallback cb(CkIndex_Hello::stageTwo(NULL),thisProxy);
	  contribute(0,NULL,CkReduction::concat,cb,17);
  }
  void stageTwo(CkReductionMsg *m) {
	  if (m->getUserFlag()!=17) CkError("Bad userFlag %d during stageTwo\n",m->getUserFlag());
	  delete m;
	  checkStage(2);
	  //When the reduction is done, it'll broadcast our stage two:
	  CkCallback cb(CkIndex_Hello::stageThree(NULL),thisProxy);
	  contribute(0,NULL,CkReduction::concat,cb,23);
  }
  void stageThree(CkReductionMsg *m) {
	  if (m->getUserFlag()!=23) CkAbort("Bad userFlag during stageThree");
	  delete m;
	  checkStage(3);
	  //When the reduction is done, it'll call main::bottleneck
	  CkCallback cb(CkIndex_Main::bottleneck(NULL),mainProxy);
	  contribute(0,NULL,CkReduction::concat,cb);
  }
  void stageFour(void) {
	  checkStage(4);
	  CkCallback cb(CkIndex_Hello::resumeMe(NULL),thisProxy);
	  contribute(0,NULL,CkReduction::concat,cb);
	  suspendedthread=CthSelf();
	  CthSuspend(); //<- thread won't awaken until resumeMe is called
	  
	  checkStage(6);
	  //When the reduction is done, it'll call main::done
	  CkCallback cb2(CkIndex_Main::done(NULL),mainProxy);
	  contribute(0,NULL,CkReduction::concat,cb2,39);
  }
  void resumeMe(CkReductionMsg *m) {
	  delete m;
	  checkStage(5);
	  CthAwaken(suspendedthread);
  }
};

#include "hello.def.h"
