/*
Global parameters and declarations for makeflo.

Orion Sky Lawlor, olawlor@acm.org, 2/1/2002
*/

#ifndef __CSAR_MAKEFLO_H
#define __CSAR_MAKEFLO_H

#include "adj.h"
#include "util.h"
#define MAKEFLO_VERSION "1.8"

const char * readBoundaries(vector<block *> &blocks,
		      const char *inMesh);

const char * splitBlocks(vector<block *> &blocks,
		      int nPieces);

void buildFaces(vector<block *> &blocks,bool buildTypeTwo);

const char * writeFlo(vector<block *> &blocks,int nPEs,
		      const char *inBcs,
		      const char *out);
const char * writeTop(vector<block *> &blocks,
		      const char *inBcs,
		      const char *out);

const char * writeMblock(vector<block *> &blocks,
                      const char *outMblock);

const char * writeBlocks(vector<block *> &blocks,
		      const char *outMesh);

class makefloParam {
 public:
	int skipAxis; //Axis to skip face builds for, or -1 if none
	int topologyOnly; //Don't write out grid locations

	int splitAxis; //Axis to split along, or -1 for any
        int splitRCB; //If 1, split using recursive bisection (optimizes communication)
	
	int nLevels; //Number of multigrid levels to create
	unsigned int levelBad; //Cuts and boundaries must not have these bits set
	unsigned int levelGood; //Cuts and boundary can only have these bits set

	makefloParam() {
		skipAxis=-1;
		topologyOnly=0;
		splitAxis=-1;
		splitRCB=0;
		setLevel(1);
	}
	void setLevel(int n) { //Use n multigrid levels
		nLevels=n;
		levelBad=(1<<(n-1))-1;
		levelGood=~levelBad;
	}
	//Print a multigrid-size diagnostic and exit
	void multigridError(void);
};
extern makefloParam parameters;


#endif

