SUBROUTINE TCHARM_User_Setup
  IMPLICIT NONE
  include 'tcharmf.h'
  include 'femf.h'
  include 'ampif.h'

  external :: myDriver
  INTEGER :: nChunks
  INTEGER :: conn(4)

  ! Read command-line parameters to determine number of mesh chunks
  !  (could also read this from a parameter file)
  nChunks=TCHARM_Get_num_chunks()
  
  CALL FEM_Print('setting up threads')
  
  ! Create the threads--one per chunk.
  !  myDriver is the routine to begin running in parallel.
  CALL TCHARM_Create(nChunks,myDriver)
  
  ! Make a one-element FEM mesh:
  CALL FEM_Print('setting up FEM mesh')
  conn(1)=1; conn(2)=2; conn(3)=3; conn(4)=4
  call FEM_Set_node(4,0)
  call FEM_Set_elem(1,1,0,4)
  call FEM_Set_elem_conn_r(1,conn)
  
  ! Attach FEM framework chunks to each thread
  CALL FEM_Attach(0)

  ! (optional)
  ! Attach an AMPI process to each thread, to allow MPI routines
  CALL MPI_Attach('main')

  CALL FEM_Print('Leaving TCHARM_User_Setup')
END SUBROUTINE

SUBROUTINE myDriver
  include 'femf.h'
  
  CALL FEM_Print('started myDriver')

END SUBROUTINE

