subroutine init()
implicit none
include 'femf.h'
include 'collidef.h'

  integer :: i, j, nelems, nnodes, esize, ignored
  integer, dimension(:,:), allocatable:: conn
  double precision, dimension(:), allocatable:: nodeData
  double precision :: gridStart(3), gridSize(3)

  call FEM_Print('init called')
  gridStart(1)=0
  gridStart(2)=0
  gridStart(3)=-1
  gridSize(1)=0.5
  gridSize(2)=0.5
  gridSize(3)=3.0
  call CollideInit(gridStart,gridSize)  

  esize=4
  nelems=10
  nnodes=(nelems)*2+2

  allocate(conn(nelems, esize))
  allocate(nodeData(nnodes))
  do i=1,nelems
    conn(i,1)=i*2-1
    conn(i,2)=i*2+0
    nodeData(conn(i,1))=i
    nodeData(conn(i,2))=i
    conn(i,3)=i*2+2
    conn(i,4)=i*2+1
  enddo
  call FEM_Set_Elem(1,nelems,0,esize)
  call FEM_Set_Elem_Conn_c(1,conn)
  
  call FEM_Set_Node(nnodes,1)
  call FEM_Set_Node_Data_r(nodeData)
end subroutine init


subroutine driver()
  use ampi
implicit none
include 'femf.h'
include 'collidef.h'

  integer  :: nnodes, nelems, myChunk, ignored
  integer, dimension(:,:), allocatable:: conn
  integer :: t, i, j, fid
  logical :: failed
  double precision :: sum
  double precision, dimension(:), allocatable:: nodes, nodeData
  double precision, dimension(:), allocatable:: elements

  integer :: nBoxes, nColl, ampi_status(AMPI_STATUS_SIZE)
  double precision, dimension(:,:), allocatable:: boxes
  double precision, dimension(:,:), allocatable:: remoteBoxes
  integer, dimension(:,:), allocatable:: collisions

  myChunk=FEM_My_Partition()

  call FEM_Get_Elem(1,nelems,ignored,ignored)
  call FEM_Get_Node(nnodes,ignored)
  allocate(nodeData(nnodes))
  call FEM_Get_Node_Data_r(nodeData)

  allocate(conn(nelems, 4))
  call FEM_Get_Elem_Conn_c(1,conn)

  allocate(nodes(nnodes))
  allocate(elements(nelems))
  nodes = 0.0
  elements = 0.0

  call FEM_Print_Partition()

  nBoxes=nelems
  allocate(boxes(6,nBoxes))

  fid = FEM_Create_Field(FEM_DOUBLE, 1, 0, 8)

  call CollideRegister(myChunk)

! This reduction is needed as a barrier; to ensure all drivers
! have called CollideRegister.
  call FEM_Reduce_Field(fid, nodes(1), sum, FEM_SUM)

! Time loop:
  do t=1,10
    call FEM_Print('----------- Starting time loop iteration ------------')

! Set up the collision bounding boxes (should actually change during time loop)
    do i=1,nBoxes
      boxes(1,i)=nodeData(conn(i,1))
      boxes(2,i)=1.1+boxes(1,i)
      boxes(3,i)=0
      boxes(4,i)=1
      boxes(5,i)=0
      boxes(6,i)=1
    end do
 
! Collide the boxes
    call Collide(myChunk,nBoxes,boxes)

! Extract the collision list
    nColl=CollideCount(myChunk)
    if (nColl .ne. 0) then
      allocate(collisions(3,nColl))
      call CollideList(myChunk,nColl,collisions)

! Print the collision list (why not?)
      write(*,*) 'Printing collision list...'
      do i=1,nColl
         write(*,*) myChunk,collisions(1,i),'->',collisions(2,i),collisions(3,i)
      end do
! Send out our entries on the collision list
      j=0  ! <- count number of remote entries
      do i=1,nColl
         if (collisions(2,i) .ne. myChunk) then
 ! Is a remote collision-- send out our involved objects
            call AMPI_Send(boxes(1,collisions(1,i)), 6, AMPI_DOUBLE_PRECISION, &
                 collisions(2,i)-1, collisions(1,i), AMPI_COMM_WORLD, ignored)
            write(*,*)myChunk,'sent box',collisions(1,i),'to',collisions(2,i)
            j=j+1
         end if
      end do

 ! Receive their involved objects
      allocate(remoteBoxes(6,j))
      j=1
      do i=1,nColl
         if (collisions(2,i) .ne. myChunk) then
 ! Is a remote collision-- receive their involved objects
            write(*,*)myChunk,'waiting on box',collisions(3,i),'from',collisions(2,i)
            call AMPI_Recv(remoteBoxes(1,j), 6, AMPI_DOUBLE_PRECISION, &
                collisions(2,i)-1, collisions(3,i), AMPI_COMM_WORLD, ampi_status, ignored)
            write(*,*)'Box data:',remoteBoxes(:,j)
            j=j+1
         end if
      end do     

! ... handle the collisions, somehow...
      deallocate(remoteBoxes)
      deallocate(collisions)
    end if

! Do other work, etc...
    call FEM_Update_Field(fid, nodes(1))	
  enddo

end subroutine driver

subroutine mesh_updated(param)
  implicit none
  integer :: param
  include 'femf.h'
  call FEM_Print('mesh_updated called')
end subroutine

subroutine finalize()
implicit none
include 'femf.h'
  call FEM_Print('finalize called')
end subroutine
