/*
Returns a view, given a viewpoint.  This version is 
local-only, for testing: it's not over CCS.

Orion Sky Lawlor, olawlor@acm.org, 8/29/2002
*/
#include <math.h>
#include <stdio.h>
#include <unistd.h>
#include "charm++.h"
#include "sixty.h"

typedef unsigned char byte;

//Draw a *tiny* set of points:
class pointSet : public CkViewable {
	CkViewableID vid;
	CkInterestSet pts;
public:
	pointSet(int np,int id)
		:vid(1,&id)
	{
		pts.setPoints(np);
		for (int i=0;i<np;i++) {
			double x=(double)(i)/(np);
			double y=x*x;
			double z=sqrt(x);
			pts[i]=CkVector3d(x,y,z);
		}
	}
	
	virtual const CkViewableID &getViewableID(void) {return vid;}
	virtual const CkInterestSet &getInterestPoints(void) {return pts;}
	
	virtual void view(const CkViewpoint &vp,CkImage &dest) {
		int np=pts.size();
		dest.clear();
		CkRect r=dest.getRect();
		for (int i=0;i<np;i++) {
			const byte src[4]={255,255,255,255};
			CkVector3d p=vp.project_noz(pts[i]);
			int px=(int)p.x, py=(int)p.y;
			if (!r.inbounds(px,py))
				CkAbort("Out-of-bounds projected point!");
			for (int dy=-2;dy<=2;dy++)
			for (int dx=-2;dx<=2;dx++)
			if (r.inbounds(px+dx,py+dy))
			dest.copyPixel(src,dest.getPixel(px+dx,py+dy));
		}
		printf("Regen.\n");
	}
	
};

class fixedViewSource : public viewSource {
	CkViewable *obj;
public:
	fixedViewSource(CkViewable *obj_) :obj(obj_) {}
	
	virtual void viewRequest(viewDest *dest,const CkViewpoint &vp) {
		CkView *v=new CkView(vp,obj);
		dest->viewResponse(v);
	}
	virtual void viewPoll(void) {
		sleep(0);
		//printf("Idle.\n");
	}
};

viewSource *createViewSource(int argc,char *argv[])
{
	return new fixedViewSource(new pointSet(8,1234));
}

