/*
Interface between GLUT event loop and the rest of the program.

Orion Sky Lawlor, olawlor@acm.org, 8/29/2002
*/

#ifndef __UIUC_PPL_CHARM_GLUTMAIN_H
#define __UIUC_PPL_CHARM_GLUTMAIN_H

enum uiEvent_t {
beginASCII=0,
endASCII=256
};

//Control the GUI:
class guiController {
public:
	virtual void draw(void) =0; //Render
	virtual void idle(void); //Went idle
	virtual void done(void); //Exited
	/*The screen is now w x h pixels*/
	virtual void reshape(int wid,int ht);
	
	virtual void mouseHover(int x,int y);
	virtual void mouseDown(int button,int x,int y);
	virtual void mouseDrag(int x,int y);
	virtual void mouseUp(int button,int x,int y);
	
	virtual void handleEvent(uiEvent_t uiCode); //Hit a key or menu
};

void glutinit(void);

//Run this gui until the user exits the program
int glutmain(const char *winName,guiController *ctl);


#endif /*def(thisHeader)*/
