#include <math.h>
#include "liveViz.h"
#include "app.decl.h"

CProxy_appArray appProxy;
int nElements;

class app: public Chare {
public:
  app(CkArgMsg *m) {
    nElements=CkNumPes();
    if (m->argc>1) nElements=atoi(m->argv[1]);
    appProxy = CProxy_appArray::ckNew(nElements);
    CkCallback c(CkIndex_appArray::requestNextFrame(0),appProxy);
    liveVizConfig cfg(false,false);
    // cfg.moreVerbose(); cfg.moreVerbose();
    liveVizInit(cfg,appProxy,c);
  }
};

class appArray: public ArrayElement1D {
public: 
  appArray(CkMigrateMessage * m) {};
  appArray() {}

  void requestNextFrame(liveVizRequestMsg *m) {
    double startTime=CmiWallTimer();
    int w=m->req.wid, h=m->req.ht;
    unsigned char *intensity=new unsigned char[w*h];
    /*
    for (int y=0;y<h;y++)
    for (int x=0;x<w;x++) {
    	int i=y*w+x;
    	intensity[i] = (byte) (10); 
    }
    */
    memset(intensity,(char) (10),w*h);
    liveVizDeposit(m, 0,0, w,h, intensity, this);
    delete[] intensity;
    double elapsed=CmiWallTimer()-startTime;
    CkPrintf("%d deposited %d x %d image in %.6f s\n",thisIndex,w,h,elapsed);
  }
};

#include "app.def.h"

