#include <stdio.h>
#include "xdrReader.h"
#include <rpc/types.h>
#include <rpc/xdr.h>

#define MAXDIM 3
#define forever for(;;)
typedef float Real;


struct dump {
    double time ;
    int nbodies ;
    int ndim ;
    int nsph ;
    int ndark ;
    int nstar ;
    int pad;
} ;

struct dump header ;

static XDR xdrs;
FILE *inp;

int xdr_header()
{
  int pad;
  
  if(xdr_double(&xdrs, &header.time) != TRUE)
    return 0;
  if(xdr_int(&xdrs, &header.nbodies) != TRUE)
    return 0;
  if(xdr_int(&xdrs, &header.ndim) != TRUE)
    return 0;
  if(xdr_int(&xdrs, &header.nsph) != TRUE)
    return 0;
  if(xdr_int(&xdrs, &header.ndark) != TRUE)
    return 0;
  if(xdr_int(&xdrs, &header.nstar) != TRUE)
    return 0;
  if(xdr_int(&xdrs, &pad) != TRUE)
    return 0;
  return 1;
}

int xdr_dark(struct dark_particle *dark)
{
      if(xdr_float(&xdrs, &dark->mass) != TRUE)
	return 0;
      if(xdr_float(&xdrs, &dark->pos[0]) != TRUE)
	return 0;
      if(xdr_float(&xdrs, &dark->pos[1]) != TRUE)
	return 0;
      if(xdr_float(&xdrs, &dark->pos[2]) != TRUE)
	return 0;
      if(xdr_float(&xdrs, &dark->vel[0]) != TRUE)
	return 0;
      if(xdr_float(&xdrs, &dark->vel[1]) != TRUE)
	return 0;
      if(xdr_float(&xdrs, &dark->vel[2]) != TRUE)
	return 0;
      if(xdr_float(&xdrs, &dark->eps) != TRUE)
	return 0;
      if(xdr_float(&xdrs, &dark->phi) != TRUE)
	return 0;
      return 1;
}  


int xdrReaderInit(FILE *fd) {
  inp = fd;
 xdrstdio_create(&xdrs, fd, XDR_DECODE);
 xdr_header();
 fprintf(stderr, "xdrReaderInit: %g %d %d %d %d %d\n", header.time,
	 header.nbodies, header.ndim, header.nsph,
	 header.ndark, header.nstar);
 
 return 1;
}

void xdrReaderDone() {
  xdr_destroy(&xdrs);
}

int xdrReaderRead(dark_particle *A, int max) 
{
    struct dark_particle dark;
    int i;
    int nRead = 0;

    if (feof(inp)) return 0;

    for (i=0; i< max; i++) {
      nRead+=xdr_dark(&dark);
      if (feof(inp)) return nRead;
      A[i]=dark;
    }

    return nRead;
}
