#include <stdio.h>
#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ CProxy_Hello helloProxy;
/*readonly*/ int nElements;

/*mainchare*/
class Main : public CBase_Main
{
  int cnt;
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    nElements=8;
    if(m->argc >1 ) nElements=atoi(m->argv[1]);
    delete m;
    cnt=0;

    //Start the computation
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mainProxy = thisProxy;

    CkGroupID BlockMapID = CProxy_BlockMap::ckNew();
    CkArrayOptions opts(nElements);
    opts.setMap(BlockMapID);
    helloProxy = CProxy_Hello::ckNew(opts);
    helloProxy.SayHi();
  }

  void done(void)
  {
    if(++cnt == nElements) {
      for(int i=0;i<nElements;i++){
        helloProxy[nElements+i].insert();
	helloProxy[nElements+i].SayHi();
      }
    }else{
      if(cnt==nElements*2)
        CkExit();
    }
  }
};

/*array [1D]*/
class Hello : public CBase_Hello
{

public:
  Hello(){}
  Hello(CkMigrateMessage *m) {}
  void SayHi()
  {
    CkPrintf("[%d] I'm on %d\n",thisIndex,CkMyPe());
    mainProxy.done();
  }
};

#include "hello.def.h"
