/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.io.IOException;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericSummaryReader;
import projections.analysis.StsReader;
import projections.gui.Analysis;
import projections.gui.OrderedIntList;
import projections.misc.MiscUtil;

public class MultiRunData {
    private StsReader[] stsReaders;
    private int[] sortedStsMap;
    private double[][][] dataTable;
    public static final int NUM_TYPES = 4;
    public static final int TYPE_TIME = 0;
    public static final int TYPE_TIMES_CALLED = 1;
    public static final int TYPE_NUM_MSG_SENT = 2;
    public static final int TYPE_SIZE_MSG = 3;
    private static final String[] typeNames = new String[]{"Execution Time", "Num Msgs Received", "Num Msgs Sent", "Msg Size"};
    private double[] runWallTimes;
    private int numRuns;
    private int numEPs;
    private String[] epNames;
    private String[] runNames;

    public MultiRunData(String[] stringArray) throws IOException {
        try {
            this.numRuns = stringArray.length;
            if (this.numRuns == 0) {
                throw new IOException("MultiRunData cannot be initialized with zero runs!");
            }
            this.stsReaders = new StsReader[this.numRuns];
            int[] nArray = new int[this.numRuns];
            int n = 0;
            while (n < this.numRuns) {
                this.stsReaders[n] = new StsReader(stringArray[n]);
                nArray[n] = this.stsReaders[n].getProcessorCount();
                ++n;
            }
            this.sortedStsMap = MiscUtil.sortAndMap(nArray);
            MiscUtil.applyMap(this.stsReaders, this.sortedStsMap);
            boolean bl = true;
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < this.numRuns) {
                bl = bl && this.stsReaders[n2].hasSumFiles();
                bl2 = bl2 && this.stsReaders[n2].hasLogFiles();
                ++n2;
            }
            this.numEPs = this.stsReaders[0].getEntryCount();
            int n3 = 1;
            while (n3 < this.numRuns) {
                if (this.numEPs != this.stsReaders[n3].getEntryCount()) {
                    System.err.println("Error! Incompatible data sets!");
                    System.exit(-1);
                }
                ++n3;
            }
            this.epNames = new String[this.numEPs];
            int n4 = 0;
            while (n4 < this.numEPs) {
                this.epNames[n4] = this.stsReaders[0].getEntryNames()[n4][0];
                ++n4;
            }
            this.runNames = new String[this.numRuns];
            int n5 = 0;
            while (n5 < this.numRuns) {
                this.runNames[n5] = "(" + nArray[n5] + ")" + "[" + this.stsReaders[n5].getMachineName() + "]";
                ++n5;
            }
            this.dataTable = new double[4][this.numRuns][this.numEPs];
            this.runWallTimes = new double[this.numRuns];
            if (bl) {
                int n6 = 0;
                while (n6 < this.numRuns) {
                    int n7 = nArray[n6];
                    OrderedIntList orderedIntList = this.stsReaders[n6].getValidProcessorList(1);
                    orderedIntList.reset();
                    double d = (double)n7 / ((double)orderedIntList.size() * 1.0);
                    ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading summary Data for run " + n6 + " of " + this.numRuns, "", 0, orderedIntList.size());
                    progressMonitor.setMillisToDecideToPopup(100);
                    progressMonitor.setMillisToPopup(1000);
                    int n8 = 0;
                    while (orderedIntList.hasMoreElements()) {
                        int n9 = orderedIntList.nextElement();
                        if (!progressMonitor.isCanceled()) {
                            progressMonitor.setNote("Reading Processor " + n9 + " data.");
                            progressMonitor.setProgress(n8);
                        } else {
                            System.err.println("Fatal error! Multirun  cannot function without  a complete read!");
                            System.exit(-1);
                        }
                        GenericSummaryReader genericSummaryReader = new GenericSummaryReader(this.stsReaders[n6].getSumName(n9), Analysis.getVersion());
                        int n10 = 0;
                        while (n10 < this.numEPs) {
                            double[] dArray = this.dataTable[0][n6];
                            int n11 = n10;
                            dArray[n11] = dArray[n11] + (double)genericSummaryReader.epData[n10][0] * d;
                            double[] dArray2 = this.dataTable[1][n6];
                            int n12 = n10;
                            dArray2[n12] = dArray2[n12] + (double)genericSummaryReader.epData[n10][1] * d;
                            ++n10;
                        }
                        int n13 = n6;
                        this.runWallTimes[n13] = this.runWallTimes[n13] + (double)genericSummaryReader.numIntervals * genericSummaryReader.intervalSize * 1000000.0 * d;
                        ++n8;
                    }
                    progressMonitor.close();
                    ++n6;
                }
            } else if (!bl2) {
                System.err.println("No data available! Catastrophic error!");
                System.exit(-1);
            }
        }
        catch (IOException iOException) {
            throw new IOException("MultiRun data read failed: 13" + iOException);
        }
    }

    public int getNumEPs() {
        return this.numEPs;
    }

    public int getNumRuns() {
        return this.numRuns;
    }

    public double[][] getData(int n) {
        return this.dataTable[n];
    }

    public double[][][] getData() {
        return this.dataTable;
    }

    public double[] getEPData(int n, int n2) {
        return this.dataTable[n][n2];
    }

    public double[] getRunData(int n, int n2) {
        double[] dArray = new double[this.numRuns];
        int n3 = 0;
        while (n3 < this.numRuns) {
            dArray[n3] = this.dataTable[n][n3][n2];
            ++n3;
        }
        return dArray;
    }

    public double[] getRunWallTimes() {
        return this.runWallTimes;
    }

    public String[] getEPNames() {
        return this.epNames;
    }

    public String[] getRunNames() {
        return this.runNames;
    }

    public static String getTypeName(int n) {
        return typeNames[n];
    }
}

