/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import projections.gui.Analysis;
import projections.gui.ColorMap;
import projections.gui.OrderedIntList;
import projections.gui.ScalePanel;
import projections.gui.U;

public class StlPanel
extends ScalePanel.Child {
    private int[][][] data;
    private int[][] utilData;
    private int[][] colors;
    private int intervalSize;
    private int nPe;
    private OrderedIntList validPEs;
    private long totalTime;
    private long startTime;
    private long endTime;
    private ColorMap colorMap;
    private int mode = 0;

    public String getPointInfo(double d, double d2) {
        try {
            int n = (int)d2;
            if (n < 0 || n >= this.nPe || d2 < 0.0) {
                return "";
            }
            long l = (long)d;
            if (l < 0L || l >= this.totalTime) {
                return "";
            }
            if (this.validPEs != null) {
                int n2 = 0;
                int n3 = 0;
                this.validPEs.reset();
                while (n2 <= n) {
                    n3 = this.validPEs.nextElement();
                    ++n2;
                }
                int n4 = Analysis.getNumUserEntries();
                int n5 = (int)(l / (long)this.intervalSize);
                int n6 = this.utilData[n3][n5];
                long l2 = l + this.startTime;
                if (this.mode == 0) {
                    return "Processor " + n3 + ": Usage = " + n6 + "%" + " at " + U.t(l2) + " (" + l2 + " us). ";
                }
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                while (n9 < n4) {
                    if (this.data[n9][n3][n5] >= n8) {
                        n8 = this.data[n9][n3][n5];
                        n7 = n9;
                    }
                    ++n9;
                }
                if (n8 > 0) {
                    return "Processor " + n3 + ": Usage = " + n6 + "%" + " at " + U.t(l2) + " (" + l2 + " us)." + " EP = " + Analysis.getEntryName(n7);
                }
                return "Processor " + n3 + ": Usage = " + n6 + "%" + " at " + U.t(l2) + " (" + l2 + " us). ";
            }
        }
        catch (Exception exception) {}
        return "";
    }

    public void paint(ScalePanel.Child.RepaintRequest repaintRequest) {
        double d = repaintRequest.y(1.0) - repaintRequest.y(0.0);
        double d2 = repaintRequest.x(1.0) - repaintRequest.x(0.0);
        double d3 = 1.0 / d;
        double d4 = 1.0 / d2;
        double d5 = repaintRequest.xInv(0.0);
        double d6 = repaintRequest.xInv(repaintRequest.w - 1);
        double d7 = repaintRequest.yInv(0.0);
        double d8 = repaintRequest.yInv(repaintRequest.h - 1);
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        if (d5 >= (double)this.totalTime) {
            d5 = (double)this.totalTime - 0.001;
        }
        if (d6 < 0.0) {
            d6 = 0.0;
        }
        if (d6 >= (double)this.totalTime) {
            d6 = (double)this.totalTime - 0.001;
        }
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        if (d7 >= (double)this.nPe) {
            d7 = (double)this.nPe - 0.001;
        }
        if (d8 < 0.0) {
            d8 = 0.0;
        }
        if (d8 >= (double)this.nPe) {
            d8 = (double)this.nPe - 0.001;
        }
        int n = (int)Math.ceil(repaintRequest.x(d5));
        int n2 = (int)Math.floor(repaintRequest.x(d6));
        int n3 = (int)Math.ceil(repaintRequest.y(d7));
        int n4 = (int)Math.floor(repaintRequest.y(d8));
        int n5 = n2 - n;
        int n6 = n4 - n3;
        double d9 = repaintRequest.xInv(n) / (double)this.intervalSize;
        double d10 = d4 / (double)this.intervalSize;
        int n7 = n2 - n;
        if (this.validPEs != null && n5 > 0 && n6 > 0) {
            int n8;
            int[] nArray = new int[n5 * n6];
            int n9 = (int)Math.floor(d7);
            int n10 = (int)Math.ceil(d8);
            this.validPEs.reset();
            int n11 = 0;
            while ((n8 = this.validPEs.nextElement()) != -1) {
                if (n8 == -1) continue;
                int n12 = (int)Math.floor(repaintRequest.y(n11));
                int n13 = (int)Math.floor(repaintRequest.y(n11 + 1));
                if (n12 < n3) {
                    n12 = n3;
                }
                if (n13 > n4) {
                    n13 = n4;
                }
                this.renderRow(this.colors[n8], d9, d10, nArray, n5, n12 - n3, n13 - n3, n - n, n2 - n);
                ++n11;
            }
            Image image = this.createImage(new MemoryImageSource(n5, n6, nArray, 0, n5));
            repaintRequest.g.drawImage(image, n, n3, null);
        }
        repaintRequest.g.setColor(Color.black);
        repaintRequest.g.fillRect(0, 0, n, n4);
        repaintRequest.g.fillRect(n, 0, repaintRequest.w, n3);
        repaintRequest.g.fillRect(n2, n3, repaintRequest.w, n4);
        repaintRequest.g.fillRect(0, n4, repaintRequest.w, repaintRequest.h);
    }

    private void renderRow(int[] nArray, double d, double d2, int[] nArray2, int n, int n2, int n3, int n4, int n5) {
        int n6 = (int)(65536.0 * d);
        int n7 = (int)(65536.0 * d2);
        int n8 = n6 + n4 * n7;
        int n9 = 0;
        int n10 = n4;
        while (n10 < n5) {
            n9 = n8 >> 16;
            if (n9 < 0) {
                n9 = 0;
            } else if (n9 >= nArray.length) {
                n8 += n7;
            } else {
                int n11 = nArray[n9];
                n8 += n7;
                int n12 = n2 * n + n10;
                int n13 = n2;
                while (n13 < n3) {
                    if (n12 < nArray2.length) {
                        nArray2[n12] = n11;
                    }
                    ++n13;
                    n12 += n;
                }
            }
            ++n10;
        }
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
    }

    private void applyColorMap(int[][] nArray) {
        int n = nArray.length;
        this.colors = new int[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2].length;
            this.colors[n2] = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                if (nArray[n2][n4] > 127 || nArray[n2][n4] < 0) {
                    nArray[n2][n4] = 127;
                }
                this.colors[n2][n4] = this.colorMap.apply((byte)nArray[n2][n4]);
                ++n4;
            }
            ++n2;
        }
    }

    private void applyColorMap(int[][][] nArray) {
        int n = nArray.length;
        int n2 = nArray[n - 1].length;
        this.colors = new int[n2][];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n - 1][n3].length;
            this.colors[n3] = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (n8 < n) {
                    if (nArray[n8][n3][n5] >= n7) {
                        n7 = nArray[n8][n3][n5];
                        n6 = n8;
                    }
                    ++n8;
                }
                this.colors[n3][n5] = n7 > 0 ? Analysis.getEntryColor(n6).getRGB() : Color.black.getRGB();
                ++n5;
            }
            ++n3;
        }
    }

    public void setMode(int n) {
        this.mode = n;
        int n2 = Analysis.getNumUserEntries();
        if (n == 0) {
            this.applyColorMap(this.utilData);
        } else if (n == 1) {
            this.setData(this.validPEs, this.startTime, this.endTime);
            this.applyColorMap(this.data);
        }
        this.repaint();
    }

    public void setData(OrderedIntList orderedIntList, long l, long l2) {
        this.validPEs = orderedIntList;
        this.totalTime = l2 - l;
        this.startTime = l;
        this.endTime = l2;
        int n = this.totalTime < 7000L ? (int)((double)this.totalTime - 1.0) : 7000;
        double d = this.totalTime / (long)n;
        if (d < 5.0) {
            d = this.totalTime / (long)(n /= 5);
        }
        this.intervalSize = (int)d;
        int n2 = (int)l / this.intervalSize;
        int n3 = (int)l2 / this.intervalSize;
        this.nPe = orderedIntList.size();
        int n4 = Analysis.getNumUserEntries();
        if (this.mode == 0) {
            Analysis.LoadGraphData(this.intervalSize, n2, n3, false, orderedIntList);
            this.utilData = Analysis.getSystemUsageData(1);
            this.applyColorMap(this.utilData);
        } else if (this.mode == 1) {
            Analysis.LoadGraphData(this.intervalSize, n2, n3, true, orderedIntList);
            this.data = new int[n4][][];
            int n5 = 0;
            while (n5 < n4) {
                this.data[n5] = Analysis.getUserEntryData(n5, 2);
                ++n5;
            }
            this.utilData = Analysis.getSystemUsageData(1);
            this.applyColorMap(this.data);
        }
        orderedIntList.reset();
        this.repaint();
    }
}

