/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import projections.gui.ScaleSlider;

public class ScalePanel
extends Panel
implements MouseMotionListener,
MouseListener {
    private Axis hor;
    private Axis ver;
    private Child child;
    private int lC;
    private int rC;
    private int tC;
    private int bC;
    private StatusDisplay statusDisplay;
    private int lastX = -1;
    private int lastY = -1;
    private boolean inDrag;

    public ScalePanel(ScaleSlider scaleSlider, ScaleSlider scaleSlider2, Child child) {
        this.child = child;
        this.child.addParent(this);
        this.add(this.child);
        this.hor = new Axis(scaleSlider, "Horizontal");
        this.ver = new Axis(scaleSlider2, "Vertical");
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    private void drawZoomCenter(Graphics graphics) {
        graphics.setColor(Color.gray);
        int n = 8;
        int n2 = (int)this.hor.getZoomCenter();
        int n3 = (int)this.ver.getZoomCenter();
        graphics.drawLine(n2 - n, n3, n2 + n, n3);
        graphics.drawLine(n2, n3 - n, n2, n3 + n);
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 300);
    }

    private void hoverPoint(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() - this.lC;
        int n2 = mouseEvent.getY() - this.tC;
        this.status(this.child.getPointInfo(this.hor.s2p(n), this.ver.s2p(n2)) + " Drag to pan");
    }

    private boolean inBounds(int n, int n2) {
        return this.lC < n && n <= this.rC && this.tC < n2 && n2 <= this.bC;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updatePoint(mouseEvent, false);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.status("");
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.inDrag) {
            if (mouseEvent.getX() > this.rC) {
                this.ver.zoomStatus("");
            } else if (mouseEvent.getY() > this.bC) {
                this.hor.zoomStatus("");
            } else {
                this.hoverPoint(mouseEvent);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.inBounds(mouseEvent.getX(), mouseEvent.getY())) {
            this.inDrag = true;
            this.status("Release mouse to end pan");
            this.updatePoint(mouseEvent, true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.status("");
        this.updatePoint(mouseEvent, false);
        this.inDrag = false;
        this.lastX = -1;
        this.lastY = -1;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4 = this.getSize().width;
        int n5 = this.getSize().height;
        int n6 = 8;
        this.lC = n3 = 2;
        this.rC = n4 - n6;
        this.tC = n3;
        this.bC = n5 - n6;
        this.hor.setScreenSize(this.rC - this.lC);
        this.ver.setScreenSize(this.bC - this.tC);
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n4, this.tC - 1);
        graphics.fillRect(0, 0, this.lC - 1, n5);
        graphics.fillRect(this.rC + 1, 0, n4, n5);
        graphics.fillRect(0, this.bC + 1, n4, n5);
        graphics.setColor(Color.gray);
        graphics.drawRect(this.lC - 1, this.tC - 1, this.rC - this.lC + 1, this.bC - this.tC + 1);
        float[] fArray = this.hor.getTicks(0.0, n4 - n6 - n3);
        int n7 = 0;
        while (n7 < fArray.length / 3) {
            n2 = this.lC + (int)fArray[n7 * 3 + 0];
            n = (int)((float)(n6 - 2) * fArray[n7 * 3 + 1]);
            graphics.drawLine(n2, n5 - n6, n2, n5 - n6 + n);
            ++n7;
        }
        fArray = this.ver.getTicks(0.0, n5 - n6 - n3);
        n2 = 0;
        while (n2 < fArray.length / 3) {
            n = this.tC + (int)fArray[n2 * 3 + 0];
            int n8 = (int)((float)(n6 - 2) * fArray[n2 * 3 + 1]);
            graphics.drawLine(n4 - n6, n, n4 - n6 + n8, n);
            ++n2;
        }
        graphics.translate(this.lC, this.tC);
        graphics.setClip(0, 0, this.rC - this.lC, this.bC - this.tC);
        this.drawZoomCenter(graphics);
        this.child.paint(new Child.RepaintRequest(graphics, this.rC - this.lC, this.bC - this.tC, this.hor, this.ver));
        this.drawZoomCenter(graphics);
    }

    public void setScales(double d, double d2) {
        this.hor.setScale(d);
        this.ver.setScale(d2);
    }

    public void setStatusDisplay(StatusDisplay statusDisplay) {
        this.statusDisplay = statusDisplay;
    }

    private void status(String string) {
        if (this.statusDisplay != null) {
            this.statusDisplay.setStatus(string);
        }
    }

    public double toSlider(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void updatePoint(MouseEvent mouseEvent, boolean bl) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if ((this.lastX != n || this.lastY != n2) && this.inDrag) {
            this.hor.setZoomCenter(n - this.lC);
            this.ver.setZoomCenter(n2 - this.tC);
            if (!bl) {
                this.hor.scroll(n - this.lastX);
                this.ver.scroll(n2 - this.lastY);
            }
            this.repaint();
        }
        this.lastX = n;
        this.lastY = n2;
    }

    public static interface StatusDisplay {
        public void setStatus(String var1);
    }

    public class Axis
    implements ScaleSlider.ValueListener {
        private String direction;
        private double screen;
        private double screenInv;
        private double p2scale;
        private double p2off;
        private double s2scale;
        private double s2off;
        private double zoomCenter;

        public double p2s(double d) {
            return this.screen * (this.p2scale * d + this.p2off);
        }

        public double s2p(double d) {
            return this.s2scale * (d * this.screenInv) + this.s2off;
        }

        public Axis(ScaleSlider scaleSlider, String string) {
            scaleSlider.setValueListener(this);
            this.direction = string;
            this.screenInv = 1.0;
            this.screen = 1.0;
            this.s2off = 0.0;
            this.p2off = 0.0;
            this.s2scale = 1.0;
            this.p2scale = 1.0;
            this.zoomCenter = 0.5;
        }

        public void setScreenSize(int n) {
            this.screen = n;
            this.screenInv = 1.0 / this.screen;
        }

        public void setScale(double d) {
            this.p2scale = 1.0 / d;
            this.s2scale = d;
            this.zoomCenter = 0.5;
        }

        public void setZoom(double d, double d2) {
            this.p2scale = d;
            this.s2off = this.s2scale * d2 + this.s2off - d2 / d;
            this.s2scale = 1.0 / d;
            this.p2off = -this.s2off / this.s2scale;
        }

        public void scroll(double d) {
            double d2 = d * this.screenInv;
            this.s2off -= d2 * this.s2scale;
            this.p2off = -this.s2off / this.s2scale;
        }

        public void zoomStatus(String string) {
            ScalePanel.this.status(this.direction + " zoom is " + string + this.p2scale);
        }

        public void sliderChanged(ScaleSlider scaleSlider) {
            double d = Math.pow(10.0, scaleSlider.getValue());
            this.setZoom(d, this.zoomCenter);
            this.zoomStatus("now ");
            ScalePanel.this.repaint();
        }

        public double getZoomCenter() {
            return this.zoomCenter * this.screen;
        }

        public void setZoomCenter(double d) {
            this.zoomCenter = d * this.screenInv;
            if (this.zoomCenter < 0.0 || this.zoomCenter > 1.0) {
                this.zoomCenter = 0.5;
            }
        }

        public float[] getTicks(double d, double d2) {
            double d3 = 7.0;
            double d4 = this.s2p(d);
            double d5 = this.s2p(d2);
            double d6 = 1.0;
            double d7 = d5 - d4;
            d6 = Math.pow(10.0, Math.ceil(-Math.log(d7 / d3) / Math.log(10.0)));
            int n = (int)Math.ceil(d4 * d6);
            int n2 = (int)Math.floor(d5 * d6);
            float f = (float)(1.0 - Math.log(d7 * d6 / d3) / Math.log(10.0));
            int n3 = n2 - n + 1;
            float[] fArray = new float[3 * n3];
            int n4 = 0;
            while (n4 < n3) {
                float f2;
                int n5 = n + n4;
                double d8 = (double)(n + n4) / d6;
                fArray[3 * n4 + 0] = (float)(d + (d2 - d) * (d8 - d4) / (d5 - d4));
                fArray[3 * n4 + 2] = (float)d8;
                if (n5 % 10 == 0) {
                    f2 = 1.0f;
                } else if (n5 % 5 == 0) {
                    f2 = 1.3f * f;
                    if (f2 > 1.0f) {
                        f2 = 1.0f;
                    }
                } else {
                    f2 = f;
                }
                fArray[3 * n4 + 1] = f2 * f2;
                ++n4;
            }
            return fArray;
        }
    }

    public static class Child
    extends Component {
        private Vector parents = new Vector();

        public void paint(RepaintRequest repaintRequest) {
            repaintRequest.g.setColor(Color.black);
            repaintRequest.g.fillRect(0, 0, repaintRequest.w, repaintRequest.h);
        }

        public String getPointInfo(double d, double d2) {
            return "At (" + d + "," + d2 + ").";
        }

        public void addParent(ScalePanel scalePanel) {
            this.parents.insertElementAt(scalePanel, this.parents.size());
        }

        public void repaint() {
            int n = 0;
            while (n < this.parents.size()) {
                ((ScalePanel)this.parents.elementAt(n)).repaint();
                ++n;
            }
        }

        public static final class RepaintRequest {
            public Graphics g;
            public int w;
            public int h;
            private Axis hor;
            private Axis ver;

            public RepaintRequest(Graphics graphics, int n, int n2, Axis axis, Axis axis2) {
                this.g = graphics;
                this.w = n;
                this.h = n2;
                this.hor = axis;
                this.ver = axis2;
            }

            public double x(double d) {
                return this.hor.p2s(d);
            }

            public double y(double d) {
                return this.ver.p2s(d);
            }

            public double xInv(double d) {
                return this.hor.s2p(d);
            }

            public double yInv(double d) {
                return this.ver.s2p(d);
            }
        }
    }
}

