/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import projections.gui.Analysis;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.FloatTextField;
import projections.gui.MainWindow;
import projections.gui.PieChartWindow;
import projections.gui.ProfileAxisCanvas;
import projections.gui.ProfileColorWindow;
import projections.gui.ProfileData;
import projections.gui.ProfileDisplayCanvas;
import projections.gui.ProfileLabelCanvas;
import projections.gui.ProfileObject;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.U;
import projections.gui.Util;

public class ProfileWindow
extends ProjectionsWindow
implements ActionListener,
AdjustmentListener,
ColorSelectable {
    private static final int NUM_SYS_EPS = 3;
    private NoUpdatePanel mainPanel;
    private NoUpdatePanel displayPanel;
    private Panel labelCanvas2;
    private Panel titlePanel;
    private ProfileLabelCanvas labelCanvas;
    private ProfileAxisCanvas axisCanvas;
    private ProfileDisplayCanvas displayCanvas;
    private ProfileColorWindow colorWindow;
    private Label lTitle;
    private Label lTitle2;
    private Scrollbar HSB;
    private Scrollbar VSB;
    private ProfileData data;
    private FloatTextField xScaleField;
    private FloatTextField yScaleField;
    private Button bDecreaseX;
    private Button bIncreaseX;
    private Button bResetX;
    private Button bDecreaseY;
    private Button bIncreaseY;
    private Button bResetY;
    private Button bColors;
    private Button bPieChart;
    private ProfileWindow thisWindow = this;
    private boolean colorsSet = false;
    private Color[][] colors;
    private ProfileObject[][] poArray;
    private float xscale = 1.0f;
    private float yscale = 1.0f;
    private float[][] avg;
    private float thresh;
    private int avgSize;
    private PieChartWindow pieChartWindow;
    private EntrySelectionDialog entryDialog;

    public ProfileWindow(MainWindow mainWindow, Integer n) {
        super(mainWindow, n);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (ProfileWindow.this.displayCanvas != null) {
                    ProfileWindow.this.setCursor(new Cursor(3));
                    ProfileWindow.this.setSizes();
                    ProfileWindow.this.setScales();
                    ProfileWindow.this.labelCanvas.makeNewImage();
                    ProfileWindow.this.axisCanvas.makeNewImage();
                    ProfileWindow.this.labelCanvas2.invalidate();
                    ProfileWindow.this.mainPanel.validate();
                    ProfileWindow.this.setCursor(new Cursor(0));
                }
            }
        });
        this.setBackground(Color.lightGray);
        this.data = new ProfileData(this);
        this.setTitle("Projections Usage Profile");
        this.CreateMenus();
        this.CreateLayout();
        this.pack();
        this.showDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            this.setCursor(new Cursor(3));
            Button button = (Button)actionEvent.getSource();
            if (button == this.bDecreaseX || button == this.bIncreaseX || button == this.bResetX) {
                if (button == this.bDecreaseX) {
                    this.xscale = (float)((int)(this.xscale * 4.0f) - 1) / 4.0f;
                    if ((double)this.xscale < 1.0) {
                        this.xscale = 1.0f;
                    }
                } else if (button == this.bIncreaseX) {
                    this.xscale = (float)((int)(this.xscale * 4.0f) + 1) / 4.0f;
                } else if (button == this.bResetX) {
                    this.xscale = 1.0f;
                }
                this.xScaleField.setText("" + this.xscale);
                this.setScales();
                this.labelCanvas.makeNewImage();
            } else if (button == this.bDecreaseY || button == this.bIncreaseY || button == this.bResetY) {
                if (button == this.bDecreaseY) {
                    this.yscale = (float)((int)(this.yscale * 4.0f) - 1) / 4.0f;
                    if ((double)this.yscale < 1.0) {
                        this.yscale = 1.0f;
                    }
                } else if (button == this.bIncreaseY) {
                    this.yscale = (float)((int)(this.yscale * 4.0f) + 1) / 4.0f;
                } else if (button == this.bResetY) {
                    this.yscale = 1.0f;
                }
                this.yScaleField.setText("" + this.yscale);
                this.setScales();
                this.axisCanvas.makeNewImage();
            } else if (button == this.bPieChart) {
                this.pieChartWindow = new PieChartWindow(this.parentWindow, this.avg[0], this.avg[0].length, this.thresh, this.colors[0]);
            } else if (button == this.bColors) {
                int n = Analysis.getNumUserEntries();
                if (this.entryDialog == null) {
                    String[] stringArray = new String[]{"Entry Points"};
                    boolean[][] blArray = new boolean[1][n + 3];
                    int n2 = 0;
                    while (n2 < n + 3) {
                        blArray[0][n2] = true;
                        ++n2;
                    }
                    boolean[][] blArray2 = new boolean[1][n + 3];
                    int n3 = 0;
                    while (n3 < n + 3) {
                        blArray2[0][n3] = true;
                        ++n3;
                    }
                    String[] stringArray2 = new String[n + 3];
                    int n4 = 0;
                    while (n4 < n) {
                        stringArray2[n4] = Analysis.getEntryName(n4);
                        ++n4;
                    }
                    stringArray2[n] = "Pack Time";
                    stringArray2[n + 1] = "Unpack Time";
                    stringArray2[n + 2] = "Idle Time";
                    this.entryDialog = new EntrySelectionDialog(this, this, stringArray, blArray2, this.colors, blArray, stringArray2);
                }
                this.entryDialog.showDialog();
            }
            this.setCursor(new Cursor(0));
        } else if (actionEvent.getSource() instanceof MenuItem) {
            String string = ((MenuItem)actionEvent.getSource()).getLabel();
            if (string.equals("Close")) {
                this.close();
            } else if (string.equals("Select Processors")) {
                this.showDialog();
            }
        } else if (actionEvent.getSource() instanceof FloatTextField) {
            this.setCursor(new Cursor(3));
            FloatTextField floatTextField = (FloatTextField)actionEvent.getSource();
            if (floatTextField == this.xScaleField) {
                this.xscale = this.xScaleField.getValue();
                this.setScales();
                this.labelCanvas.makeNewImage();
            } else if (floatTextField == this.yScaleField) {
                this.yscale = this.yScaleField.getValue();
                this.setScales();
                this.axisCanvas.makeNewImage();
            }
            this.setCursor(new Cursor(0));
        }
    }

    public void applyDialogColors() {
        this.MakePOArray(this.data.begintime, this.data.endtime);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Scrollbar scrollbar = (Scrollbar)adjustmentEvent.getSource();
        this.displayCanvas.setLocation(-this.HSB.getValue(), -this.VSB.getValue());
        if (scrollbar == this.HSB) {
            this.labelCanvas.repaint();
        } else if (scrollbar == this.VSB) {
            this.axisCanvas.repaint();
        }
    }

    private void CreateLayout() {
        this.mainPanel = new NoUpdatePanel();
        this.displayPanel = new NoUpdatePanel();
        this.labelCanvas = new ProfileLabelCanvas(this.data);
        this.labelCanvas2 = new NoUpdatePanel();
        this.axisCanvas = new ProfileAxisCanvas(this.data);
        this.displayCanvas = new ProfileDisplayCanvas(this.data);
        this.HSB = new Scrollbar(0, 0, 1, 0, 1);
        this.VSB = new Scrollbar(1, 0, 1, 0, 1);
        this.mainPanel.setLayout(null);
        this.mainPanel.setBackground(Color.black);
        this.mainPanel.add(this.labelCanvas);
        this.mainPanel.add(this.labelCanvas2);
        this.mainPanel.add(this.axisCanvas);
        this.mainPanel.add(this.displayPanel);
        this.mainPanel.add(this.HSB);
        this.mainPanel.add(this.VSB);
        this.mainPanel.setSize(new Dimension(600, 400));
        this.displayPanel.setLayout(null);
        this.displayPanel.add(this.displayCanvas);
        this.HSB.setBackground(Color.lightGray);
        this.HSB.addAdjustmentListener(this);
        this.VSB.setBackground(Color.lightGray);
        this.VSB.addAdjustmentListener(this);
        this.bColors = new Button("Change Colors");
        this.bDecreaseY = new Button("<<");
        this.bIncreaseY = new Button(">>");
        this.bResetY = new Button("Reset");
        this.bDecreaseX = new Button("<<");
        this.bIncreaseX = new Button(">>");
        this.bResetX = new Button("Reset");
        this.bPieChart = new Button("Pie Chart");
        this.bColors.addActionListener(this);
        this.bDecreaseY.addActionListener(this);
        this.bIncreaseY.addActionListener(this);
        this.bResetY.addActionListener(this);
        this.bDecreaseX.addActionListener(this);
        this.bIncreaseX.addActionListener(this);
        this.bResetX.addActionListener(this);
        this.bPieChart.addActionListener(this);
        Label label = new Label("X-SCALE: ", 1);
        this.xScaleField = new FloatTextField(this.xscale, 5);
        this.xScaleField.addActionListener(this);
        Label label2 = new Label("Y-SCALE: ", 1);
        this.yScaleField = new FloatTextField(this.yscale, 5);
        this.yScaleField.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        Util.gblAdd(panel, this.bDecreaseY, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, label2, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.yScaleField, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bIncreaseY, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bResetY, gridBagConstraints, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, new Label("  "), gridBagConstraints, 5, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bDecreaseX, gridBagConstraints, 6, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, label, gridBagConstraints, 7, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.xScaleField, gridBagConstraints, 8, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bIncreaseX, gridBagConstraints, 9, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bResetX, gridBagConstraints, 10, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bPieChart, gridBagConstraints, 11, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.bColors, gridBagConstraints, 12, 0, 1, 1, 1, 1);
        Panel panel2 = new Panel();
        panel2.setBackground(Color.black);
        panel2.setForeground(Color.white);
        Label label3 = new Label("%", 1);
        panel2.setLayout(gridBagLayout);
        Util.gblAdd(panel2, label3, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        this.titlePanel = new Panel();
        this.titlePanel.setBackground(Color.black);
        this.titlePanel.setForeground(Color.white);
        this.lTitle = new Label("", 1);
        this.lTitle.setFont(new Font("SansSerif", 1, 16));
        this.lTitle2 = new Label("", 1);
        this.lTitle2.setFont(new Font("SansSerif", 1, 16));
        this.titlePanel.setLayout(gridBagLayout);
        Util.gblAdd(this.titlePanel, this.lTitle, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(this.titlePanel, this.lTitle2, gridBagConstraints, 0, 1, 1, 1, 1, 1);
        JPanel jPanel = new JPanel();
        this.getContentPane().add(jPanel);
        jPanel.setLayout(gridBagLayout);
        Util.gblAdd(jPanel, panel2, gridBagConstraints, 0, 0, 1, 2, 0, 1);
        Util.gblAdd(jPanel, this.titlePanel, gridBagConstraints, 1, 0, 1, 1, 1, 0);
        Util.gblAdd(jPanel, this.mainPanel, gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(jPanel, panel, gridBagConstraints, 0, 2, 2, 1, 1, 0);
    }

    private void CreateMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Select Processors", "Print Profile", null, "Close"}, this));
        Menu menu = new Menu("Help");
        menuBar.add(Util.makeMenu(menu, new Object[]{"Index", "About"}, this));
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
    }

    public int getHSBValue() {
        return this.HSB.getValue();
    }

    public int getVSBValue() {
        return this.VSB.getValue();
    }

    public void MakePOArray(long l, long l2) {
        Object object;
        int n;
        Object object2;
        int n2;
        int n3;
        int n4 = Analysis.getNumUserEntries();
        if (!this.colorsSet) {
            this.colors = new Color[1][n4 + 3];
            n3 = 0;
            while (n3 < n4) {
                this.colors[0][n3] = Analysis.getEntryColor(n3);
                ++n3;
            }
            this.colors[0][n4] = Color.black;
            this.colors[0][n4 + 1] = Color.orange;
            this.colors[0][n4 + 2] = Color.white;
        }
        this.displayCanvas.removeAll();
        this.data.numPs = this.data.plist.size() + 1;
        this.poArray = new ProfileObject[this.data.numPs][];
        n3 = Analysis.getNumUserEntries();
        this.avg = new float[2][n3 + 3];
        double d = 1.0 / (double)this.data.plist.size();
        int n5 = 1;
        int n6 = 0;
        int n7 = this.data.plist.size();
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Computing Usage Values", "", 0, n7 * 2);
        progressMonitor.setProgress(0);
        this.data.plist.reset();
        int n8 = 0;
        while (n8 < this.avg[0].length) {
            this.avg[0][n8] = 0.0f;
            this.avg[1][n8] = 0.0f;
            ++n8;
        }
        while (this.data.plist.hasMoreElements()) {
            n2 = this.data.plist.currentElement();
            if (progressMonitor.isCanceled()) break;
            progressMonitor.setNote("Computing Average : " + n2);
            progressMonitor.setProgress(n6);
            this.data.plist.nextElement();
            object2 = Analysis.GetUsageData(n2, l, l2, this.data.phaselist);
            n = 0;
            while (n < this.avg[0].length && n < ((Object)object2[0]).length) {
                float[] fArray = this.avg[0];
                int n9 = n;
                fArray[n9] = fArray[n9] + (float)((double)object2[0][n] * d);
                float[] fArray2 = this.avg[1];
                int n10 = n;
                fArray2[n10] = fArray2[n10] + (float)((double)object2[1][n] * d);
                ++n;
            }
            ++n6;
        }
        progressMonitor.setNote("Assigning Colors");
        progressMonitor.setProgress(n6);
        object2 = new Vector<Integer>();
        n = 0;
        while (n < n4) {
            if ((double)(this.avg[0][n] + this.avg[1][n]) > 1.0) {
                ((Vector)object2).add(new Integer(n));
            }
            ++n;
        }
        int[] nArray = new int[((Vector)object2).size()];
        int n11 = 0;
        while (n11 < nArray.length) {
            nArray[n11] = (Integer)((Vector)object2).elementAt(n11);
            ++n11;
        }
        if (!this.colorsSet) {
            object = Analysis.createColorMap(n4, nArray);
            int n12 = 0;
            while (n12 < ((Color[])object).length) {
                this.colors[0][n12] = object[n12];
                ++n12;
            }
            this.colorsSet = true;
        }
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            n2 = this.data.plist.currentElement();
            if (progressMonitor.isCanceled()) break;
            progressMonitor.setNote("Reading Entry Point Usage : " + n2);
            progressMonitor.setProgress(n6);
            this.data.plist.nextElement();
            object = Analysis.GetUsageData(n2, l, l2, this.data.phaselist);
            this.usage2po((float[][])object, n2, n5++, this.colors[0]);
            ++n6;
        }
        this.usage2po(this.avg, -1, 0, this.colors[0]);
        progressMonitor.close();
        object = "Profile of Usage for Processor";
        if (this.data.plist.size() > 1) {
            object = (String)object + "s";
        }
        object = (String)object + " " + this.data.plist.listToString();
        this.lTitle.setText((String)object);
        this.lTitle.invalidate();
        object = "(Time " + U.t(l) + " - " + U.t(l2) + ")";
        this.lTitle2.setText((String)object);
        this.lTitle2.invalidate();
        this.titlePanel.validate();
        this.setSizes();
        this.setScales();
        this.labelCanvas.makeNewImage();
        this.axisCanvas.makeNewImage();
        this.labelCanvas2.invalidate();
        this.mainPanel.validate();
    }

    private void setScales() {
        this.data.dcw = (int)(this.xscale * (float)this.data.vpw);
        this.data.dch = (int)(this.yscale * (float)this.data.vph);
        if (this.xscale > 1.0f) {
            this.HSB.setVisible(true);
        } else {
            this.HSB.setVisible(false);
        }
        if (this.yscale > 1.0f) {
            this.VSB.setVisible(true);
        } else {
            this.VSB.setVisible(false);
        }
        this.HSB.setMaximum(this.data.dcw);
        this.VSB.setMaximum(this.data.dch);
        this.HSB.setVisibleAmount(this.data.vpw);
        this.VSB.setVisibleAmount(this.data.vph);
        this.HSB.setBlockIncrement(this.data.vpw);
        this.VSB.setBlockIncrement(this.data.vph);
        this.displayCanvas.setBounds(0, 0, this.data.dcw, this.data.dch);
        double d = (double)(this.data.dch - this.data.offset) / 100.0;
        float f = (float)(this.data.dcw - 2 * this.data.offset) / (float)this.data.numPs;
        int n = (int)Math.ceil(0.75 * (double)f);
        int n2 = (int)((f - (float)n) / 2.0f);
        if (this.poArray != null) {
            int n3 = 0;
            while (n3 < this.data.numPs) {
                int n4 = this.data.dch;
                double d2 = 0.0;
                if (this.poArray[n3] != null) {
                    int n5 = 0;
                    while (n5 < this.poArray[n3].length) {
                        if (this.poArray[n3][n5] != null) {
                            double d3 = d * (double)this.poArray[n3][n5].getUsage();
                            int n6 = (d3 += d2) - (double)((int)d3) >= 0.5 ? (int)d3 + 1 : (int)d3;
                            d2 = d3 - (double)n6;
                            this.poArray[n3][n5].setBounds((int)(f * (float)n3 + (float)this.data.offset + (float)n2), n4 - n6, n, n6);
                            n4 -= n6;
                        } else {
                            System.out.println("POARRAY[" + n3 + "][" + n5 + "} IS NULL");
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        this.displayCanvas.makeNewImage();
    }

    private void setSizes() {
        int n = this.mainPanel.getSize().width;
        int n2 = this.mainPanel.getSize().height;
        int n3 = 50;
        int n4 = 30;
        int n5 = 30;
        int n6 = 20;
        int n7 = 20;
        this.data.vpw = n - n3 - n7;
        this.data.vph = n2 - n4 - n5 - n6;
        this.data.dcw = (int)(this.xscale * (float)this.data.vpw);
        this.data.dch = (int)(this.yscale * (float)this.data.vph);
        if (this.xscale > 1.0f) {
            this.HSB.setVisible(true);
        } else {
            this.HSB.setVisible(false);
        }
        if (this.yscale > 1.0f) {
            this.VSB.setVisible(true);
        } else {
            this.VSB.setVisible(false);
        }
        this.HSB.setMaximum(this.data.dcw);
        this.VSB.setMaximum(this.data.dch);
        this.HSB.setBlockIncrement(this.data.vpw);
        this.VSB.setBlockIncrement(this.data.vph);
        this.axisCanvas.setBounds(0, 0, n3, this.data.vph);
        this.displayPanel.setBounds(n3, 0, this.data.vpw, this.data.vph);
        this.displayCanvas.setBounds(0, 0, this.data.dcw, this.data.dch);
        this.labelCanvas.setBounds(n3, this.data.vph, this.data.vpw, n4);
        this.labelCanvas2.setBounds(n3, this.data.vph + n4, this.data.vpw, n5);
        this.VSB.setBounds(n - n7, 0, n7, this.data.vph);
        this.HSB.setBounds(n3, n2 - n6, this.data.vpw, n6);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "Usage Profile");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    ProfileWindow.this.thisWindow.MakePOArray(((ProfileWindow)ProfileWindow.this).data.begintime, ((ProfileWindow)ProfileWindow.this).data.endtime);
                    return null;
                }

                public void finished() {
                    ProfileWindow.this.thisWindow.setVisible(true);
                }
            };
            swingWorker.start();
        }
    }

    public void showWindow() {
    }

    public void getDialogData() {
        this.data.plist = this.dialog.getValidProcessors();
        this.data.pstring = this.dialog.getValidProcessorString();
        this.data.begintime = this.dialog.getStartTime();
        this.data.endtime = this.dialog.getEndTime();
    }

    private void usage2po(float[][] fArray, int n, int n2, Color[] colorArray) {
        String string;
        int n3;
        float f;
        int n4 = Analysis.getNumUserEntries();
        String[][] stringArray = Analysis.getEntryNames();
        int n5 = 0;
        int n6 = 0;
        float f2 = 0.01f;
        int n7 = 0;
        while (n7 < fArray[0].length) {
            if (fArray[0][n7] > f2) {
                ++n6;
            }
            if (fArray[1][n7] > f2) {
                ++n6;
            }
            ++n7;
        }
        this.poArray[n2] = new ProfileObject[n6];
        n7 = 0;
        while (n7 < fArray[0].length) {
            f = fArray[0][n7];
            if (!(f <= f2)) {
                n3 = n7;
                if (n3 < n4) {
                    string = stringArray[n3][1] + "::" + stringArray[n3][0];
                } else if (n3 == n4 + 2) {
                    string = "IDLE";
                } else if (n3 == n4) {
                    string = "PACKING";
                } else {
                    if (n3 != n4 + 1) break;
                    string = "UNPACKING";
                }
                this.poArray[n2][n5] = new ProfileObject(f, string, n);
                this.displayCanvas.add(this.poArray[n2][n5]);
                this.poArray[n2][n5].setForeground(colorArray[n3]);
                ++n5;
            }
            ++n7;
        }
        if (Analysis.getVersion() > 4.9) {
            n7 = 0;
            while (n7 < fArray[1].length) {
                f = fArray[1][n7];
                if (!(f <= f2)) {
                    n3 = n7;
                    if (n3 < n4) {
                        string = "Message Send Time: " + stringArray[n3][1] + "::" + stringArray[n3][0];
                    } else if (n3 == n4 + 2) {
                        string = "Message Send Time: IDLE";
                    } else if (n3 == n4) {
                        string = "Message Send Time: PACKING";
                    } else {
                        if (n3 != n4 + 1) break;
                        string = "Message Send Time: UNPACKING";
                    }
                    this.poArray[n2][n5] = new ProfileObject(f, string, n);
                    this.displayCanvas.add(this.poArray[n2][n5]);
                    this.poArray[n2][n5].setForeground(colorArray[n3]);
                    ++n5;
                }
                ++n7;
            }
        }
    }

    class NoUpdatePanel
    extends Panel {
        NoUpdatePanel() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

