/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import projections.gui.ProfileData;

public class ProfileAxisCanvas
extends Canvas {
    private ProfileData data;
    private Image offscreen;
    private FontMetrics fm;
    private int textheight;

    public ProfileAxisCanvas(ProfileData profileData) {
        this.data = profileData;
        this.setForeground(Color.white);
        this.setBackground(Color.black);
    }

    private void drawAxis(Graphics graphics) {
        int n;
        int n2 = this.getSize().width;
        if (this.fm == null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
            this.textheight = this.fm.getHeight();
        }
        graphics.setColor(this.getForeground());
        graphics.drawLine(n2 - 1, this.data.offset, n2 - 1, this.data.dch);
        float f = (float)((double)(this.data.dch - this.data.offset) / 100.0);
        int n3 = (int)Math.ceil((float)this.textheight / f);
        int[] nArray = new int[]{1, 2, 5, 25};
        int n4 = -1;
        int n5 = 0;
        while (n5 < nArray.length) {
            n = 0;
            int n6 = 0;
            while ((n6 = (int)((double)nArray[n5] * Math.pow(10.0, n))) < n3) {
                ++n;
            }
            if (n6 - n3 < n4 - n3 || n4 < 0) {
                n4 = n6;
            }
            ++n5;
        }
        n3 = n4;
        int n7 = 0;
        while (n7 <= 100) {
            n = this.data.dch - (int)((float)n7 * f) - 1;
            if (n7 % n3 == 0) {
                String string = "" + n7;
                graphics.drawLine(n2 - 10, n, n2, n);
                n += (int)(0.5 * (double)this.textheight);
                if (n7 != 0) {
                    graphics.drawString(string, n2 - 15 - this.fm.stringWidth(string), n);
                }
            } else {
                graphics.drawLine(n2 - 7, n, n2, n);
            }
            ++n7;
        }
    }

    public void makeNewImage() {
        this.offscreen = null;
        if (this.data.plist == null) {
            return;
        }
        int n = this.getSize().width;
        if (n > 0 && this.data.dch > 0) {
            this.offscreen = this.createImage(n, this.data.dch + 30);
            if (this.offscreen == null) {
                return;
            }
            Graphics graphics = this.offscreen.getGraphics();
            graphics.setClip(0, 0, n, this.data.dch);
            this.drawAxis(graphics);
            graphics.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen != null) {
            int n = this.data.profileWindow.getVSBValue();
            int n2 = this.getSize().width;
            graphics.drawImage(this.offscreen, 0, 0, n2, this.data.vph, 0, n, n2, this.data.vph + n, null);
        }
    }

    public void print(Graphics graphics) {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        int n = this.data.profileWindow.getVSBValue();
        graphics.translate(0, -n);
        this.drawAxis(graphics);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

