/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;

public class OrderedGraphDataList {
    private Link head;
    private Link tail;
    private Link pre;
    private int len;

    public Color currentC() {
        Link link = this.nextLink();
        if (link == null) {
            return null;
        }
        return link.color;
    }

    public int currentY() {
        Link link = this.nextLink();
        if (link == null) {
            return -1;
        }
        return link.height;
    }

    public boolean hasMoreElements() {
        return this.nextLink() != null;
    }

    public void insert(int n, Color color) {
        this.reset();
        Link link = this.nextLink();
        while (link != null && link.height < n) {
            this.pre = link;
            link = this.nextLink();
        }
        if (link == null) {
            Link link2 = new Link(n, color, link);
            if (this.head == null) {
                this.head = link2;
                this.tail = link2;
            } else {
                this.pre.next = link2;
                this.tail = link2;
            }
            ++this.len;
        } else if (n == link.height) {
            link.color = color;
        } else {
            Link link3 = new Link(n, color, link);
            if (this.head == link) {
                this.head = link3;
            } else {
                this.pre.next = link3;
            }
            ++this.len;
        }
    }

    public void nextElement() {
        this.pre = this.pre == null ? this.head : this.pre.next;
    }

    private Link nextLink() {
        if (this.pre == null) {
            return this.head;
        }
        return this.pre.next;
    }

    public void removeAll() {
        this.pre = null;
        this.head = null;
        this.tail = null;
        this.len = 0;
    }

    public void reset() {
        this.pre = null;
    }

    public int size() {
        return this.len;
    }

    class Link {
        int height;
        Color color;
        Link next;

        Link(int n, Color color, Link link) {
            this.height = n;
            this.color = color;
            this.next = link;
        }
    }
}

