/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import projections.analysis.MultiRunDataAnalyzer;
import projections.gui.count.TableSorter;
import projections.misc.MultiRunTableModel;

public class MultiRunTables
extends JTabbedPane {
    private MultiRunDataAnalyzer analysisModule;

    public MultiRunTables(int n, MultiRunDataAnalyzer multiRunDataAnalyzer) {
        this.analysisModule = multiRunDataAnalyzer;
        String[] stringArray = multiRunDataAnalyzer.getCategoryNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.makeTable(stringArray[n2], null, Color.black, n, n2);
            ++n2;
        }
    }

    public void setType(int n) {
        int n2 = this.getTabCount();
        int n3 = 0;
        while (n3 < n2) {
            JTable jTable = (JTable)((JScrollPane)this.getComponentAt(n3)).getViewport().getView();
            MultiRunTableModel multiRunTableModel = (MultiRunTableModel)((TableSorter)jTable.getModel()).getModel();
            multiRunTableModel.setType(n);
            jTable.repaint();
            ++n3;
        }
    }

    public void makeTable(String string, String string2, Color color, int n, int n2) {
        MultiRunTableModel multiRunTableModel = new MultiRunTableModel(string, this.analysisModule, n, n2);
        TableSorter tableSorter = new TableSorter(multiRunTableModel);
        JTable jTable = new JTable(tableSorter);
        tableSorter.addMouseListenerToHeaderInTable(jTable);
        this.initColumnSizes(jTable);
        jTable.setAutoResizeMode(0);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 500));
        this.addTab(string, null, jScrollPane, string2);
        this.setForegroundAt(this.indexOfComponent(jScrollPane), color);
    }

    private void initColumnSizes(JTable jTable) {
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        int n = 0;
        while (n < jTable.getColumnCount()) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            tableColumn.setHeaderRenderer(tableCellRenderer);
            Component component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            int n2 = component.getPreferredSize().width;
            tableColumn.setPreferredWidth(n2);
            ++n;
        }
    }
}

