/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import projections.gui.MainWindow;
import projections.gui.MenuManager;

public class MainMenuManager
extends MenuManager
implements ActionListener,
ItemListener {
    private JMenu fileMenu;
    private JMenu preferencesMenu;
    private JMenu toolMenu;
    private JMenu counterMenu;
    private static final int NO_DATA = 0;
    private static final int OPENED_FILES = 1;
    private MainWindow parent;

    public MainMenuManager(JFrame jFrame) {
        super(jFrame);
        this.parent = (MainWindow)jFrame;
        this.createMenus();
    }

    void stateChanged(int n) {
        switch (n) {
            case 0: {
                this.setEnabled(this.fileMenu, new boolean[]{true, false, false, false, true});
                this.setEnabled(this.preferencesMenu, new boolean[]{true, true, false, false});
                this.setEnabled(this.toolMenu, new boolean[]{false, false, false, false, false, false, false, false, false, true});
                break;
            }
            case 1: {
                this.setEnabled(this.fileMenu, new boolean[]{true, true, true, false, true});
                this.setAllTo(this.preferencesMenu, true);
                this.setAllTo(this.toolMenu, true);
            }
        }
    }

    private void createMenus() {
        this.fileMenu = this.makeJMenu("File", new Object[]{"Open File(s)", "Close current data", "Close all data", null, "Quit"});
        this.menubar.add(this.fileMenu);
        this.preferencesMenu = this.makeJMenu("Preferences", new Object[]{"Change Background Color", "Change Foreground Color", "Use Default Grayscale Colors", "Use Standard Colors"});
        this.menubar.add(this.preferencesMenu);
        this.toolMenu = this.makeJMenu("Tools", new Object[]{"Graphs", "Timelines", "Usage Profile", "Communication Histogram", "View Log Files", "Histograms", "Overview", "Animation", "General Graph", "Multirun Analysis"});
        this.menubar.add(this.toolMenu);
        this.stateChanged(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            if (string.equals("Open File(s)")) {
                this.parent.showOpenFileDialog();
            }
            if (string.equals("Close current data")) {
                this.parent.closeCurrent();
            } else if (string.equals("Close all data")) {
                this.parent.closeAll();
            } else if (string.equals("Quit")) {
                this.parent.shutdown();
            } else if (string.equals("Change Background Color")) {
                this.parent.changeBackground();
            } else if (string.equals("Change Foreground Color")) {
                this.parent.changeForeground();
            } else if (string.equals("Use Default Grayscale Colors")) {
                this.parent.setGrayscale();
            } else if (string.equals("Use Standard Colors")) {
                this.parent.setFullColor();
            } else if (string.equals("Multirun Analysis") || string.equals("Histograms") || string.equals("Graphs") || string.equals("Timelines") || string.equals("Usage Profile") || string.equals("Communication Histogram") || string.equals("View Log Files") || string.equals("Animation") || string.equals("General Graph") || string.equals("Overview")) {
                this.parent.menuToolSelected(string);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void fileOpened() {
        this.stateChanged(1);
    }

    public void lastFileClosed() {
        this.stateChanged(0);
    }
}

