/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.EOFException;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericLogReader;
import projections.gui.Analysis;
import projections.gui.EntryPointWindow;
import projections.gui.EntrySelectionDialog;
import projections.gui.GenericGraphWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.RangeDialog;
import projections.gui.SwingWorker;
import projections.gui.Util;
import projections.misc.LogEntryData;

public class HistogramWindow
extends GenericGraphWindow
implements ActionListener,
ItemListener {
    static final int NO_OF_BINS = 25;
    static final int FREQUENCY = 100;
    private long totalExecutionTime;
    private long longestExecutionTime;
    private EntrySelectionDialog entryDialog;
    private boolean[][] stateArray;
    private Color[][] colorArray;
    private String[] entryNames;
    private JTextArea statusArea;
    private boolean recordEP;
    private EntryPointWindow epFrame;
    private boolean startUp;
    private HistogramWindow thisWindow = this;

    public HistogramWindow(MainWindow mainWindow, Integer n) {
        super("Projections Histograms", mainWindow, n);
        this.setTitle("Projections Histograms");
        this.setGraphSpecificData();
        int n2 = Analysis.getNumUserEntries();
        this.stateArray = new boolean[1][n2];
        int n3 = 0;
        while (n3 < n2) {
            this.stateArray[0][n3] = true;
            ++n3;
        }
        String[][] stringArray = Analysis.getEntryNames();
        this.entryNames = new String[n2];
        int n4 = 0;
        while (n4 < n2) {
            this.entryNames[n4] = stringArray[n4][0];
            ++n4;
        }
        this.colorArray = new Color[1][n2];
        int n5 = 0;
        while (n5 < n2) {
            this.colorArray[0][n5] = Analysis.getEntryColor(n5);
            ++n5;
        }
        this.recordEP = true;
        this.epFrame = null;
        this.statusArea = new JTextArea(6, 2);
        this.startUp = true;
        this.createMenus();
        this.getContentPane().add(this.getMainPanel());
        this.pack();
        this.showDialog();
    }

    public void close() {
        if (this.epFrame != null) {
            this.epFrame.dispose();
        }
        super.close();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "Select Histogram Time Range");
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    if (!HistogramWindow.this.startUp) {
                        HistogramWindow.this.thisWindow.refreshGraph();
                    } else {
                        HistogramWindow.this.thisWindow.showEntryDialog();
                    }
                    return null;
                }

                public void finished() {
                    HistogramWindow.this.thisWindow.setVisible(true);
                }
            };
            swingWorker.start();
        }
    }

    public void showWindow() {
    }

    public void getDialogData() {
        super.getDialogData();
    }

    void showEntryDialog() {
        if (this.startUp) {
            this.startUp = false;
        }
        int n = Analysis.getNumUserEntries();
        String[] stringArray = new String[]{"Entry Points"};
        boolean[][] blArray = new boolean[1][n];
        int n2 = 0;
        while (n2 < n) {
            blArray[0][n2] = true;
            ++n2;
        }
        if (this.entryDialog == null) {
            this.entryDialog = new EntrySelectionDialog(this, stringArray, this.stateArray, this.colorArray, blArray, this.entryNames);
        }
        this.entryDialog.showDialog();
        this.refreshGraph();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            if (jMenuItem.getText().equals("Set Range")) {
                this.showDialog();
            } else if (jMenuItem.getText().equals("Select Entry Points")) {
                this.showEntryDialog();
            } else if (jMenuItem.getText().equals("Close")) {
                this.close();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.recordEP = itemEvent.getStateChange() == 1;
        if (this.recordEP) {
            this.refreshGraph();
        } else {
            this.epFrame.setVisible(false);
        }
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = super.getMainPanel();
        jPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        jPanel.add(new JScrollPane(this.statusArea, 20, 30));
        return jPanel;
    }

    protected void setGraphSpecificData() {
        this.setXAxis("Entry Point Execution Time (us)", "us", 0.0, 100.0);
        this.setYAxis("Instances", "");
    }

    protected void refreshGraph() {
        int[] nArray = this.getCounts();
        this.setDataSource("", nArray);
        super.refreshGraph();
        String string = "Bin  ";
        String string2 = "EPs  ";
        String string3 = "Total Execution Time: " + String.valueOf(this.totalExecutionTime) + " us";
        String string4 = "Longest Entry Point Execution Time: " + this.longestExecutionTime + " us";
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != 0) {
                string = string + n + "\t";
                string2 = string2 + nArray[n] + "\t";
            }
            ++n;
        }
        this.statusArea.setText("");
        this.statusArea.append(string + "\n");
        this.statusArea.append(string2 + "\n\n");
        this.statusArea.append(string3 + "\n");
        this.statusArea.append(string4);
    }

    public String[] getPopup(int n, int n2) {
        return null;
    }

    private int[] getCounts() {
        int n = 0;
        this.totalExecutionTime = 0L;
        this.longestExecutionTime = 0L;
        OrderedIntList orderedIntList = this.validPEs.copyOf();
        if (this.recordEP) {
            if (this.epFrame == null) {
                this.epFrame = new EntryPointWindow();
                this.epFrame.setSize(600, 600);
            } else {
                this.epFrame.clearTableData();
            }
        }
        int[] nArray = new int[25];
        int n2 = 0;
        while (n2 < 25) {
            nArray[n2] = 0;
            ++n2;
        }
        LogEntryData logEntryData = new LogEntryData();
        LogEntryData logEntryData2 = new LogEntryData();
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Reading log files", "", 0, orderedIntList.size());
        int n3 = 0;
        while (orderedIntList.hasMoreElements()) {
            int n4 = orderedIntList.nextElement();
            if (!progressMonitor.isCanceled()) {
                progressMonitor.setNote("Reading data for PE " + n4);
                progressMonitor.setProgress(n3);
            } else {
                progressMonitor.close();
            }
            ++n3;
            GenericLogReader genericLogReader = new GenericLogReader(Analysis.getLogName(n4), Analysis.getVersion());
            try {
                genericLogReader.nextEventOnOrAfter(this.startTime, logEntryData);
                do {
                    genericLogReader.nextEventOfType(2, logEntryData);
                    genericLogReader.nextEventOfType(3, logEntryData2);
                    if (!this.stateArray[0][logEntryData.entry]) continue;
                    long l = logEntryData2.time - logEntryData.time;
                    this.totalExecutionTime += l;
                    int n5 = (int)(l / 100L);
                    if (n5 >= 25) {
                        if (this.recordEP) {
                            this.epFrame.writeToTable(n4, this.entryNames[logEntryData.entry], logEntryData.time, logEntryData2.time, this.colorArray[0][logEntryData.entry]);
                        }
                        this.longestExecutionTime = l > this.longestExecutionTime ? l : this.longestExecutionTime;
                        n5 = 24;
                    }
                    int n6 = n5;
                    nArray[n6] = nArray[n6] + 1;
                    ++n;
                } while (logEntryData2.time <= this.endTime);
            }
            catch (EOFException eOFException) {
            }
            catch (Exception exception) {
                System.out.println("Exception " + exception);
                exception.printStackTrace();
            }
        }
        progressMonitor.close();
        if (this.recordEP) {
            this.epFrame.setVisible(true);
        }
        return nArray;
    }

    protected void createMenus() {
        this.fileMenu = Util.makeJMenu(this.fileMenu, new Object[]{"Select Entry Points"}, null, this);
        this.menuBar.add(Util.makeJMenu("View", new Object[]{new JCheckBoxMenuItem("Show Longest EPs", true)}, null, this));
        super.createMenus();
    }
}

