/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import projections.gui.GraphData;
import projections.gui.Util;

public class GraphWAxisCanvas
extends Canvas {
    private GraphData data;
    private int width = 0;
    private int textheight = 0;
    private int labelwidth = 0;
    private int labelincrement = 0;
    private double deltay = 0.0;

    public GraphWAxisCanvas() {
        this.setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public int getPreferredWidth() {
        Graphics graphics;
        if (this.width == 0 && (graphics = this.getGraphics()) != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            this.width = fontMetrics.stringWidth("100") + fontMetrics.stringWidth("%") + 20;
            graphics.dispose();
        }
        return this.width;
    }

    public void paint(Graphics graphics) {
        if (this.data == null) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height - this.data.offset2;
        if (this.textheight == 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            this.textheight = fontMetrics.getHeight();
            this.labelwidth = fontMetrics.stringWidth("%");
        }
        graphics.setColor(this.getForeground());
        graphics.drawString("%", n - 5 - this.labelwidth, n2 / 2);
        graphics.drawLine(5, this.data.offset, 5, n2 - 1);
        int n3 = 0;
        while (n3 <= 100) {
            int n4 = n2 - (int)((double)n3 * this.deltay) - 1;
            if (n3 % this.labelincrement == 0) {
                graphics.drawLine(0, n4, 10, n4);
                graphics.drawString("" + n3, 15, n4 += (int)(0.5 * (double)this.textheight));
            } else {
                graphics.drawLine(3, n4, 7, n4);
            }
            ++n3;
        }
    }

    public void print(Graphics graphics) {
        ((Graphics2D)graphics).setBackground(Color.white);
        this.setForeground(Color.black);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.clearRect(0, 0, n, n2);
        this.paint(graphics);
        ((Graphics2D)graphics).setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.textheight == 0) {
            Graphics graphics = this.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
            this.textheight = fontMetrics.getHeight();
            this.labelwidth = fontMetrics.stringWidth("%");
            graphics.dispose();
        }
        this.deltay = (double)(n4 - this.data.offset - this.data.offset2) / 100.0;
        this.labelincrement = (int)Math.ceil((double)(this.textheight + 10) / this.deltay);
        this.labelincrement = Util.getBestIncrement(this.labelincrement);
        this.data.wscale = this.deltay;
        super.setBounds(n, n2, n3, n4);
    }

    public void setData(GraphData graphData) {
        this.data = graphData;
    }
}

