/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import projections.analysis.IntervalCapableReader;
import projections.analysis.IntervalUtils;
import projections.analysis.ParseTokenizer;
import projections.analysis.ProjectionsFormatException;
import projections.analysis.ProjectionsReader;

public class AccumulatedSummaryReader
extends ProjectionsReader
implements IntervalCapableReader {
    public int numProcessors;
    public long numIntervals;
    public double intervalSize;
    public double totalTime;
    private double[] utilization;

    public AccumulatedSummaryReader(String string, String string2) {
        super(string, string2);
    }

    protected boolean checkAvailable() {
        File file = new File(this.sourceString);
        return file.canRead();
    }

    protected void readStaticData() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.sourceString));
        ParseTokenizer parseTokenizer = this.initNewTokenizer(bufferedReader);
        try {
            parseTokenizer.checkNextString("ver");
            double d = parseTokenizer.nextNumber("Version");
            if (d != Double.parseDouble(this.expectedVersion)) {
                throw new ProjectionsFormatException(this.expectedVersion, "Expected version does not match one read on file!");
            }
            parseTokenizer.checkNextString("pes");
            this.numProcessors = (int)parseTokenizer.nextNumber("Total Number of Processors");
            parseTokenizer.checkNextString("count");
            this.numIntervals = (long)parseTokenizer.nextNumber("Number of Intervals");
            parseTokenizer.checkNextString("interval");
            this.intervalSize = parseTokenizer.nextScientific("Interval Size") * 1000000.0;
            this.totalTime = (double)this.numIntervals * this.intervalSize;
            if (!parseTokenizer.isEOL()) {
                throw new ProjectionsFormatException(this.expectedVersion, "Extra Stuff at the end of header line.");
            }
        }
        catch (IOException iOException) {
            throw new ProjectionsFormatException(this.expectedVersion, iOException.toString());
        }
        bufferedReader.close();
    }

    public void reset() throws IOException {
    }

    private ParseTokenizer initNewTokenizer(Reader reader) {
        ParseTokenizer parseTokenizer = new ParseTokenizer(reader);
        parseTokenizer.parseNumbers();
        parseTokenizer.eolIsSignificant(true);
        parseTokenizer.whitespaceChars(47, 47);
        parseTokenizer.whitespaceChars(58, 58);
        parseTokenizer.whitespaceChars(91, 91);
        parseTokenizer.whitespaceChars(93, 93);
        parseTokenizer.wordChars(97, 122);
        parseTokenizer.wordChars(65, 90);
        return parseTokenizer;
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    public void loadIntervalData(long l, long l2) throws IOException {
        this.loadIntervalData(this.intervalSize, l, l2);
    }

    public void loadIntervalData(double d, long l, long l2) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.sourceString));
        ParseTokenizer parseTokenizer = this.initNewTokenizer(bufferedReader);
        int n = (int)(l2 - l + 1L);
        this.utilization = new double[n];
        parseTokenizer.skipLine();
        double d2 = this.intervalSize;
        double d3 = d * (double)l;
        double d4 = (double)l2 * d;
        long l3 = 0L;
        double d5 = Double.MIN_VALUE;
        while (!parseTokenizer.isEOL()) {
            if ((double)(l3 + 1L) * d2 < d3) {
                ++l3;
                continue;
            }
            double d6 = parseTokenizer.nval;
            IntervalUtils.fillIntervals(this.utilization, d, (int)l, (double)l3 * d2, (double)(l3 + 1L) * d2 - d5, d2 * (d6 / 100.0), false);
            if ((double)(++l3) * d2 > d4) break;
        }
        if (parseTokenizer.isEOL()) {
            throw new ProjectionsFormatException(this.expectedVersion, "Unexpected EOL when reading utilization data!");
        }
        bufferedReader.close();
        IntervalUtils.timeToUtil(this.utilization, d);
    }

    public double[] getUtilData() {
        return this.utilization;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        AccumulatedSummaryReader accumulatedSummaryReader = new AccumulatedSummaryReader(string, "5.0");
        System.out.println(accumulatedSummaryReader.getIntervalSize());
        System.out.println(accumulatedSummaryReader.numProcessors);
        System.out.println(accumulatedSummaryReader.numIntervals);
        System.out.println(accumulatedSummaryReader.intervalSize);
        System.out.println(accumulatedSummaryReader.totalTime);
        try {
            accumulatedSummaryReader.loadIntervalData(0L, accumulatedSummaryReader.numIntervals - 1L);
            double[] dArray = accumulatedSummaryReader.getUtilData();
            int n = 0;
            while (n < dArray.length) {
                System.out.print((long)dArray[n] + " ");
                ++n;
            }
            System.out.println();
            accumulatedSummaryReader.reset();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }
}

