/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.EpPList;
import charm.debug.PListOutputArea;
import charm.debug.ParamsDialog;
import charm.debug.ServThread;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PConsumer;
import charm.debug.fmt.PList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ParDebug
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static String filename;
    private static String hostname;
    private static String portnumber;
    private static int numberPes;
    private static String clparams;
    private static String envDisplay;
    private CcsServer ccs;
    private DefaultListModel listModel;
    private PList listItems = null;
    private boolean isRunning = false;
    private boolean[] peList = null;
    private CpdListInfo[] cpdLists = new CpdListInfo[]{new CpdListInfo("-- Display --", null, null), new CpdListInfo("Array Elements", "charm/arrayElementNames", "charm/arrayElements"), new CpdListInfo("Messages in Queue", "converse/localqueue", null), new CpdListInfo("Readonly Variables", "charm/readonly", null), new CpdListInfo("Readonly Messages", "charm/readonlyMsg", null), new CpdListInfo("Entry Points", "charm/entries", null), new CpdListInfo("Chare Types", "charm/chares", null), new CpdListInfo("Message Types", "charm/messages", null), new CpdListInfo("Mainchares", "charm/mains", null), new CpdListInfo("Viewable Lists", "converse/lists", null)};
    private static JFrame appFrame;
    private JButton startButton;
    private JButton continueButton;
    private JButton quitButton;
    private JButton freezeButton;
    private JButton startGdbButton;
    private JPanel peActualPanel;
    private JPanel sysEpsActualPanel;
    private JPanel userEpsActualPanel;
    private JTextArea programOutputArea;
    private PListOutputArea outputArea;
    private JTextField statusArea;
    private JComboBox listsbox;
    private JComboBox pesbox;
    private JList listItemNames;
    private JMenuBar menuBar;
    private JMenu menuFile;
    private JMenu menuAction;
    private JMenuItem menuFileOpen;
    private JMenuItem menuFileParameters;
    private JMenuItem menuActionStart;
    private JMenuItem menuActionContinue;
    private JMenuItem menuActionQuit;
    private JMenuItem menuActionFreeze;

    private int getListLength(String string, int n) {
        try {
            int n2 = string.length();
            int n3 = 4 + n2 + 1;
            byte[] byArray = new byte[n3];
            CcsServer.writeInt(byArray, 0, n2);
            CcsServer.writeString(byArray, 4, n2 + 1, string);
            CcsServer.Request request2 = this.ccs.sendRequest("ccs_list_len", n, byArray);
            byte[] byArray2 = this.ccs.recvResponse(request2);
            if (byArray2.length < 4) {
                return -1;
            }
            return CcsServer.readInt(byArray2, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.abort("Network error connecting to PE " + n + " to access list " + string);
            return 0;
        }
    }

    private byte[] byteList(String string, String string2, int n, int n2, int n3) {
        try {
            int n4 = string.length();
            int n5 = 16 + n4 + 1;
            byte[] byArray = new byte[n5];
            CcsServer.writeInt(byArray, 0, n2);
            CcsServer.writeInt(byArray, 4, n3);
            CcsServer.writeInt(byArray, 8, 0);
            CcsServer.writeInt(byArray, 12, n4);
            CcsServer.writeString(byArray, 16, n4 + 1, string);
            CcsServer.Request request2 = this.ccs.sendRequest("ccs_list_items." + string2, n, byArray);
            return this.ccs.recvResponse(request2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.abort("Network error connecting to PE " + n + " to access list " + string);
            return null;
        }
    }

    private PList getPList(String string, int n, int n2, int n3) {
        byte[] byArray = this.byteList(string, "fmt", n, n2, n3);
        PConsumer pConsumer = new PConsumer();
        pConsumer.decode(byArray);
        return pConsumer.getList();
    }

    private String sendCcsRequest(String string, String string2, int n) {
        try {
            int n2 = string2.length();
            int n3 = n2 + 1;
            byte[] byArray = new byte[n3];
            CcsServer.writeString(byArray, 0, n2 + 1, string2);
            CcsServer.Request request2 = this.ccs.sendRequest(string, n, byArray);
            if (string2.equalsIgnoreCase("freeze") || string.equalsIgnoreCase("ccs_debug_quit") || string.equalsIgnoreCase("ccs_remove_all_break_points") || string.equalsIgnoreCase("ccs_set_break_point") || string.equalsIgnoreCase("ccs_remove_break_point") || string.equalsIgnoreCase("ccs_continue_break_point")) {
                return null;
            }
            byte[] byArray2 = this.ccs.recvResponse(request2);
            return new String(byArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.abort("Network error connecting to PE " + n + " to perform " + string);
            return null;
        }
    }

    private void bcastCcsRequest(String string, String string2, int n) {
        if (n <= 0) {
            int n2 = 0;
            while (n2 < numberPes) {
                this.sendCcsRequest(string, string2, n2);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < numberPes) {
                if (this.peList[n3]) {
                    this.sendCcsRequest(string, string2, n3);
                }
                ++n3;
            }
        }
    }

    private void abort(String string) {
        System.out.println(string);
        System.exit(1);
    }

    private String getEnvDisplay() {
        String string = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
            string = string2 + ":0.0";
            System.out.println("DISPLAY variable = " + string);
        }
        catch (Exception exception) {
            this.abort("Error retrieving IP address for DISPLAY variable: " + exception.getMessage());
        }
        return string;
    }

    public void displayProgramOutput(String string) {
        this.programOutputArea.append(string);
        this.programOutputArea.scrollRectToVisible(new Rectangle(0, this.programOutputArea.getHeight() - 2, 1, 1));
    }

    private static void setNumberPes(String string) {
        try {
            numberPes = Integer.parseInt(string);
        }
        catch (Exception exception) {
            System.out.println("Could not convert number of pes " + string + " to an integer.");
            System.exit(1);
        }
    }

    public void setParametersForProgram(String string, String string2, String string3) {
        ParDebug.setNumberPes(string2);
        clparams = string;
        portnumber = string3;
        this.addedRunParameter();
    }

    private void addedRunParameter() {
        this.setStatusMessage("Executable: " + filename + "        number of pes: " + numberPes);
    }

    public void setStatusMessage(String string) {
        this.statusArea.setText(string);
    }

    private void populateNewList(int n, int n2, DefaultListModel defaultListModel) {
        defaultListModel.removeAllElements();
        this.outputArea.setList(null);
        this.listItems = null;
        String string = this.cpdLists[n].name;
        if (string == null) {
            return;
        }
        int n3 = this.getListLength(string, n2);
        this.listItems = this.getPList(string, n2, 0, n3);
        PAbstract pAbstract = this.listItems.elementAt(0);
        while (pAbstract != null) {
            defaultListModel.addElement(pAbstract.getDeepName());
            pAbstract = pAbstract.getNext();
        }
    }

    private void expandListElement(int n, int n2, int n3) {
        String string = this.cpdLists[n].detailedName;
        if (string == null) {
            this.outputArea.setList((PList)this.listItems.elementAt(n3));
        } else {
            PList pList = this.getPList(string, n2, n3, n3 + 1);
            this.outputArea.setList((PList)pList.elementAt(0));
        }
    }

    private void listenTo(JMenuItem jMenuItem, String string, String string2) {
        if (string2 != null) {
            jMenuItem.setToolTipText(string2);
        }
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this);
    }

    public ParDebug() {
        this.setLayout(new BoxLayout(this, 1));
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuBar.add(this.menuFile);
        this.menuFile.setMnemonic('F');
        this.menuFileOpen = new JMenuItem("Open Program", 79);
        this.menuFile.add(this.menuFileOpen);
        this.listenTo(this.menuFileOpen, "browse", "Open a parallel program to debug");
        this.menuFileParameters = new JMenuItem("Program Parameters", 80);
        this.menuFile.add(this.menuFileParameters);
        this.listenTo(this.menuFileParameters, "params", "Enter command-line parameters for the parallel program");
        JMenuItem jMenuItem = new JMenuItem("Exit Debugger", 88);
        this.menuFile.add(jMenuItem);
        this.listenTo(jMenuItem, "exitDebugger", null);
        this.menuAction = new JMenu("Action");
        this.menuBar.add(this.menuAction);
        this.menuAction.setMnemonic('A');
        this.menuActionStart = new JMenuItem("Start", 83);
        this.menuAction.add(this.menuActionStart);
        this.listenTo(this.menuActionStart, "begin", "Start the parallel program");
        this.menuActionContinue = new JMenuItem("Continue", 67);
        this.menuAction.add(this.menuActionContinue);
        this.listenTo(this.menuActionContinue, "unfreeze", "Continue to run the parallel program");
        this.menuActionFreeze = new JMenuItem("Freeze", 70);
        this.menuAction.add(this.menuActionFreeze);
        this.listenTo(this.menuActionFreeze, "freeze", "Freeze the parallel program");
        this.menuActionQuit = new JMenuItem("Quit", 81);
        this.menuAction.add(this.menuActionQuit);
        this.listenTo(this.menuActionQuit, "quit", "Quit the parallel program");
        this.statusArea = new JTextField(60);
        this.statusArea.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusArea.setEditable(false);
        this.statusArea.setBackground(Color.lightGray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Set Break Points"), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        jPanel2.setPreferredSize(new Dimension(200, 380));
        this.sysEpsActualPanel = new JPanel();
        this.sysEpsActualPanel.setLayout(new BoxLayout(this.sysEpsActualPanel, 1));
        JScrollPane jScrollPane = new JScrollPane(this.sysEpsActualPanel);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("System Entry Points"));
        jScrollPane.setPreferredSize(new Dimension(200, 185));
        this.userEpsActualPanel = new JPanel();
        this.userEpsActualPanel.setLayout(new BoxLayout(this.userEpsActualPanel, 1));
        JScrollPane jScrollPane2 = new JScrollPane(this.userEpsActualPanel);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("User Entry Points"));
        jScrollPane2.setPreferredSize(new Dimension(200, 185));
        jPanel2.add(jScrollPane);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel2.add(jScrollPane2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Control Buttons"), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        jPanel4.setPreferredSize(new Dimension(500, 80));
        this.startButton = new JButton("Start");
        this.startButton.setVerticalTextPosition(0);
        this.startButton.setHorizontalTextPosition(2);
        this.startButton.setMnemonic(83);
        this.startButton.setActionCommand("begin");
        this.startButton.setEnabled(true);
        this.startButton.setToolTipText("Run the parallel program from scratch.");
        this.startButton.addActionListener(this);
        this.startButton.setPreferredSize(new Dimension(100, 80));
        this.continueButton = new JButton("Continue");
        this.continueButton.setVerticalTextPosition(3);
        this.continueButton.setHorizontalTextPosition(0);
        this.continueButton.setMnemonic(85);
        this.continueButton.setActionCommand("unfreeze");
        this.continueButton.setEnabled(false);
        this.continueButton.setToolTipText("Resume execution.");
        this.continueButton.addActionListener(this);
        this.continueButton.setPreferredSize(new Dimension(100, 80));
        this.freezeButton = new JButton("Freeze");
        this.freezeButton.setVerticalTextPosition(3);
        this.freezeButton.setHorizontalTextPosition(0);
        this.freezeButton.setActionCommand("freeze");
        this.freezeButton.setEnabled(false);
        this.freezeButton.setToolTipText("Stop execution.");
        this.freezeButton.addActionListener(this);
        this.freezeButton.setPreferredSize(new Dimension(100, 80));
        this.quitButton = new JButton("Quit");
        this.quitButton.setVerticalTextPosition(3);
        this.quitButton.setHorizontalTextPosition(0);
        this.quitButton.setMnemonic(81);
        this.quitButton.setActionCommand("quit");
        this.quitButton.setEnabled(false);
        this.quitButton.setToolTipText("End the program.");
        this.quitButton.addActionListener(this);
        this.quitButton.setPreferredSize(new Dimension(100, 80));
        this.startGdbButton = new JButton("Start GDB");
        this.startGdbButton.setVerticalTextPosition(3);
        this.startGdbButton.setHorizontalTextPosition(0);
        this.startGdbButton.setActionCommand("startgdb");
        this.startGdbButton.setEnabled(false);
        this.startGdbButton.setToolTipText("Start gdb on selected processors.");
        this.startGdbButton.addActionListener(this);
        this.startGdbButton.setPreferredSize(new Dimension(100, 80));
        jPanel4.add(this.startButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.continueButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.freezeButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.quitButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add(this.startGdbButton);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.programOutputArea = new JTextArea();
        this.programOutputArea.setColumns(100);
        this.programOutputArea.setLineWrap(true);
        JScrollPane jScrollPane3 = new JScrollPane(this.programOutputArea);
        jScrollPane3.setBorder(BorderFactory.createTitledBorder("Program Output"));
        jScrollPane3.setPreferredSize(new Dimension(350, 300));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setPreferredSize(new Dimension(50, 380));
        this.peActualPanel = new JPanel();
        this.peActualPanel.setLayout(new BoxLayout(this.peActualPanel, 1));
        JScrollPane jScrollPane4 = new JScrollPane(this.peActualPanel);
        jScrollPane4.setBorder(BorderFactory.createTitledBorder("Pes"));
        jPanel6.add(jScrollPane4);
        jPanel5.add(jScrollPane3);
        jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel5.add(jPanel6);
        jPanel5.setPreferredSize(new Dimension(500, 300));
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel3.add(jPanel5);
        jPanel3.setPreferredSize(new Dimension(500, 380));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        jPanel.add(jPanel3);
        jPanel.setPreferredSize(new Dimension(600, 380));
        this.add(this.statusArea);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        this.add(jPanel);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jPanel7.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("View Entities on PE"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        String[] stringArray = new String[this.cpdLists.length];
        int n = 0;
        while (n < this.cpdLists.length) {
            stringArray[n] = this.cpdLists[n].display;
            ++n;
        }
        this.listsbox = new JComboBox<String>(stringArray);
        this.listsbox.setActionCommand("lists");
        this.listsbox.addActionListener(this);
        this.listsbox.setEnabled(false);
        this.listsbox.setPreferredSize(new Dimension(450, 70));
        this.pesbox = new JComboBox();
        this.pesbox.addActionListener(this);
        this.pesbox.setEnabled(false);
        this.pesbox.setPreferredSize(new Dimension(100, 70));
        jPanel7.add(this.listsbox);
        jPanel7.add(Box.createRigidArea(new Dimension(50, 70)));
        jPanel7.add(this.pesbox);
        jPanel7.setPreferredSize(new Dimension(600, 70));
        this.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        jPanel8.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        jPanel8.setPreferredSize(new Dimension(600, 230));
        this.listModel = new DefaultListModel();
        this.listItemNames = new JList(this.listModel);
        this.listItemNames.setSelectionMode(0);
        this.listItemNames.addListSelectionListener(this);
        JScrollPane jScrollPane5 = new JScrollPane(this.listItemNames);
        jScrollPane5.setBorder(BorderFactory.createTitledBorder("Entities"));
        this.outputArea = new PListOutputArea();
        JScrollPane jScrollPane6 = new JScrollPane(this.outputArea);
        jScrollPane6.setHorizontalScrollBarPolicy(31);
        jScrollPane6.setBorder(BorderFactory.createTitledBorder("Details"));
        jScrollPane5.setPreferredSize(new Dimension(200, 230));
        jScrollPane6.setPreferredSize(new Dimension(400, 230));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane5, jScrollPane6);
        jSplitPane.setOneTouchExpandable(true);
        jPanel8.add(jSplitPane);
        this.add(jPanel8);
        this.addedRunParameter();
        if (filename != "") {
            this.startProgram();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        if (actionEvent.getActionCommand().equals("browse")) {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                filename = jFileChooser.getSelectedFile().getAbsolutePath();
                this.addedRunParameter();
            }
        } else if (actionEvent.getActionCommand().equals("params")) {
            ParamsDialog paramsDialog = new ParamsDialog((Frame)appFrame, true, this);
            paramsDialog.setLocationRelativeTo(appFrame);
            paramsDialog.setFields(clparams, "" + numberPes, portnumber);
            paramsDialog.pack();
            paramsDialog.setVisible(true);
        } else if (actionEvent.getActionCommand().equals("begin")) {
            this.startProgram();
        } else if (actionEvent.getActionCommand().equals("freeze")) {
            this.bcastCcsRequest("ccs_debug", "freeze", 1);
            this.continueButton.setEnabled(true);
            this.freezeButton.setEnabled(false);
            this.setStatusMessage("Program is frozen on selected pes");
        } else if (actionEvent.getActionCommand().equals("unfreeze")) {
            this.bcastCcsRequest("ccs_continue_break_point", "", 0);
            this.continueButton.setEnabled(true);
            this.freezeButton.setEnabled(true);
            this.setStatusMessage("Program is running");
        } else if (actionEvent.getActionCommand().equals("quit")) {
            this.bcastCcsRequest("ccs_debug_quit", "", 0);
            this.quitProgram();
        } else if (actionEvent.getActionCommand().equals("startgdb")) {
            this.bcastCcsRequest("ccs_remove_all_break_points", "", 0);
            this.bcastCcsRequest("ccs_debug_startgdb", "", 1);
            this.setStatusMessage("Gdb started on selected pes");
        } else if (actionEvent.getActionCommand().equals("breakpoints")) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            String string = jCheckBox.getText();
            if (jCheckBox.isSelected()) {
                this.bcastCcsRequest("ccs_set_break_point", string, 0);
                this.continueButton.setEnabled(true);
                this.freezeButton.setEnabled(false);
                this.setStatusMessage("Break Point set at entry point " + string);
            } else {
                this.bcastCcsRequest("ccs_remove_break_point", string, 0);
                this.continueButton.setEnabled(true);
                this.freezeButton.setEnabled(true);
                this.setStatusMessage("Break Point removed at entry point " + string + " on selected Pes");
            }
        } else if (actionEvent.getActionCommand().equals("pecheck")) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            String string = jCheckBox.getText();
            String string2 = string.substring(3);
            this.peList[Integer.parseInt((String)string2)] = jCheckBox.isSelected();
        } else if (actionEvent.getActionCommand().equals("lists") || actionEvent.getActionCommand().equals("changepe")) {
            int n = Integer.parseInt((String)this.pesbox.getSelectedItem());
            this.populateNewList(this.listsbox.getSelectedIndex(), n, this.listModel);
        } else if (actionEvent.getActionCommand().equals("exitDebugger")) {
            this.quitProgram();
            System.exit(0);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList == this.listItemNames && !jList.isSelectionEmpty()) {
            int n = Integer.parseInt((String)this.pesbox.getSelectedItem());
            this.expandListElement(this.listsbox.getSelectedIndex(), n, jList.getSelectedIndex());
        }
    }

    public void startProgram() {
        JCheckBox jCheckBox;
        String string;
        Serializable serializable;
        Object object;
        this.isRunning = true;
        this.programOutputArea.setText("");
        String string2 = filename;
        String string3 = new File(string2).getParent();
        if (string3 == null) {
            string3 = ".";
        }
        String string4 = string3 + "/charmrun";
        if (envDisplay.length() == 0) {
            envDisplay = this.getEnvDisplay();
        }
        String string5 = string4 + " " + "+p" + numberPes + " " + string2 + " " + clparams + "  +cpd +DebugDisplay " + envDisplay + " ++server";
        if (portnumber.length() != 0) {
            string5 = string5 + " ++server-port " + portnumber;
        }
        System.out.println("ParDebug> " + string5);
        this.programOutputArea.setText(string5);
        Process process = null;
        Runtime runtime = null;
        runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(string5);
        }
        catch (Exception exception) {
            System.out.println("ParDebug> Error executing " + string5);
            this.quitProgram();
            return;
        }
        ServThread servThread = new ServThread(this, process);
        servThread.start();
        long l = 0L;
        while (servThread.portno == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (l++ <= 600L) continue;
            this.abort("Timeout waiting for program to start up (and print its CCS port number)");
        }
        if (portnumber.length() == 0) {
            portnumber = servThread.portno;
        }
        System.out.println("ParDebug> Charmrun started (CCS port " + portnumber + ")");
        String[] stringArray = new String[]{hostname, portnumber};
        this.ccs = CcsServer.create(stringArray, false);
        this.peList = new boolean[numberPes];
        int n = 0;
        while (n < numberPes) {
            String string6 = new Integer(n).toString();
            this.pesbox.addItem(string6);
            object = "pe " + string6;
            serializable = new JCheckBox((String)object);
            this.peActualPanel.add((Component)serializable);
            ((AbstractButton)serializable).setSelected(true);
            ((AbstractButton)serializable).addActionListener(this);
            ((AbstractButton)serializable).setActionCommand("pecheck");
            this.peList[n] = true;
            ++n;
        }
        this.peActualPanel.updateUI();
        this.pesbox.setActionCommand("changepe");
        this.startButton.setEnabled(false);
        this.continueButton.setEnabled(true);
        this.quitButton.setEnabled(false);
        this.freezeButton.setEnabled(false);
        this.startGdbButton.setEnabled(true);
        int n2 = this.getListLength("charm/entries", 0);
        object = new EpPList(this.getPList("charm/entries", 0, 0, n2));
        serializable = ((EpPList)object).getUserEps();
        int n3 = ((Vector)serializable).size();
        int n4 = 0;
        while (n4 < n3) {
            string = ((Vector)serializable).elementAt(n4).toString();
            ++n4;
            jCheckBox = new JCheckBox(string);
            jCheckBox.addActionListener(this);
            jCheckBox.setActionCommand("breakpoints");
            this.userEpsActualPanel.add(jCheckBox);
        }
        this.userEpsActualPanel.updateUI();
        serializable = ((EpPList)object).getSystemEps();
        n3 = ((Vector)serializable).size();
        n4 = 0;
        while (n4 < n3) {
            string = ((Vector)serializable).elementAt(n4).toString();
            ++n4;
            jCheckBox = new JCheckBox(string);
            jCheckBox.addActionListener(this);
            jCheckBox.setActionCommand("breakpoints");
            this.sysEpsActualPanel.add(jCheckBox);
        }
        this.sysEpsActualPanel.updateUI();
        this.listsbox.setEnabled(true);
        this.pesbox.setEnabled(true);
        this.quitButton.setEnabled(true);
    }

    public void quitProgram() {
        portnumber = "";
        this.isRunning = false;
        this.startButton.setEnabled(true);
        this.continueButton.setEnabled(false);
        this.quitButton.setEnabled(false);
        this.freezeButton.setEnabled(false);
        this.startGdbButton.setEnabled(false);
        this.listModel.removeAllElements();
        this.outputArea.setList(null);
        this.listsbox.setEnabled(false);
        this.pesbox.removeAllItems();
        this.pesbox.setActionCommand("");
        this.pesbox.setEnabled(false);
        this.peActualPanel.removeAll();
        this.peActualPanel.updateUI();
        this.userEpsActualPanel.removeAll();
        this.userEpsActualPanel.updateUI();
        this.sysEpsActualPanel.removeAll();
        this.sysEpsActualPanel.updateUI();
        this.setStatusMessage(new String("Ready to start new program"));
    }

    public static void printUsage() {
        System.out.println("Usage: java ParDebug [[-file <charm program name>] [[-param \"<charm program parameters>\"][-pes <number of pes>]] [-host <hostname>] [-port <port>] [-display <display>]]");
    }

    public static void main(String[] stringArray) {
        hostname = "localhost";
        filename = "";
        portnumber = "";
        numberPes = 1;
        String string = "1";
        clparams = "";
        envDisplay = "";
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-host")) {
                hostname = stringArray[n + 1];
            } else if (stringArray[n].equals("-port")) {
                portnumber = stringArray[n + 1];
            } else if (stringArray[n].equals("-file")) {
                filename = stringArray[n + 1];
            } else if (stringArray[n].equals("-param")) {
                clparams = stringArray[n + 1];
            } else if (stringArray[n].equals("-pes") || stringArray[n].equals("+p")) {
                string = stringArray[n + 1];
            } else if (stringArray[n].equals("-display")) {
                envDisplay = stringArray[n + 1];
            } else {
                if (stringArray[n].startsWith("+p")) {
                    string = stringArray[n].substring(2);
                } else if (!bl) {
                    if (stringArray[n].startsWith("-") || stringArray[n].startsWith("+")) {
                        ParDebug.printUsage();
                        System.exit(1);
                    } else {
                        filename = stringArray[n];
                        bl = true;
                    }
                } else {
                    clparams = clparams + " " + stringArray[n];
                }
                --n;
            }
            n += 2;
        }
        if (n > stringArray.length) {
            ParDebug.printUsage();
            System.exit(1);
        }
        ParDebug.setNumberPes(string);
        appFrame = new JFrame("Charm Parallel Debugger");
        appFrame.setSize(1000, 1000);
        final ParDebug parDebug = new ParDebug();
        appFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (parDebug.isRunning) {
                    parDebug.bcastCcsRequest("ccs_debug_quit", "", -1);
                }
                System.exit(0);
            }
        });
        appFrame.getContentPane().add((Component)parDebug, "Center");
        Rectangle rectangle = appFrame.getGraphicsConfiguration().getBounds();
        appFrame.setLocation(50 + rectangle.x, 50 + rectangle.y);
        appFrame.setJMenuBar(parDebug.menuBar);
        appFrame.pack();
        appFrame.setVisible(true);
    }

    static {
        appFrame = null;
    }

    private class CpdListInfo {
        public String display;
        public String name;
        public String detailedName;

        public CpdListInfo(String string, String string2) {
            this.display = string;
            this.name = string2;
            this.detailedName = null;
        }

        public CpdListInfo(String string, String string2, String string3) {
            this.display = string;
            this.name = string2;
            this.detailedName = string3;
        }
    }
}

