/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.Consumer;

public class Verbose
extends Consumer {
    private int indent = 0;

    private String startLine(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.indent + n) {
            stringBuffer.append("\t");
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String startLine() {
        return this.startLine(0);
    }

    private void beginCollection(String string) {
        System.out.println(this.startLine() + string + " = {");
        ++this.indent;
    }

    private void endCollection(String string) {
        --this.indent;
        System.out.println(this.startLine() + "} " + string);
    }

    private String beginArray(String string, int n) {
        if (n > 1) {
            this.beginCollection(string + " array");
            System.out.print(this.startLine());
            return "";
        }
        System.out.print(this.startLine() + string + "=");
        return "";
    }

    private void endArray(String string, int n) {
        if (n > 1) {
            System.out.println();
            this.endCollection(string + " array");
        } else {
            System.out.println();
        }
    }

    public void listByte(byte[] byArray) {
        System.out.println(this.startLine() + "byte[] = '" + new String(byArray) + "'");
    }

    public void listInt(int[] nArray) {
        String string = this.beginArray("int", nArray.length);
        int n = 0;
        while (n < nArray.length) {
            System.out.print(string + nArray[n] + ", ");
            ++n;
        }
        this.endArray("int", nArray.length);
    }

    public void listFloat(float[] fArray) {
        String string = this.beginArray("float", fArray.length);
        int n = 0;
        while (n < fArray.length) {
            System.out.print(string + fArray[n] + ", ");
            ++n;
        }
        this.endArray("float", fArray.length);
    }

    public void listComment(String string) {
        System.out.println(this.startLine() + "//" + string + "");
    }

    public void listSync(int n) {
        switch (n) {
            case 0x71100000: {
                this.beginCollection("array");
                break;
            }
            case 1913651200: {
                this.endCollection("array");
                break;
            }
            case 1897922560: {
                this.beginCollection("list");
                break;
            }
            case 0x72200000: {
                this.endCollection("list");
                break;
            }
            case 1898971136: {
                this.beginCollection("object");
                break;
            }
            case 1915748352: {
                this.endCollection("object");
                break;
            }
            case 1880227840: {
                System.out.println("\n" + this.startLine(-1) + "/* Index */");
                break;
            }
            case 0x70110000: {
                System.out.println(this.startLine(-1) + ",/* Element */");
                break;
            }
            case 0x79000000: {
                System.out.println(this.startLine() + ",/* --- end of system crap ---- */");
                break;
            }
            default: {
                System.out.println(this.startLine() + "  (sync=0x" + Integer.toHexString(n) + ")");
            }
        }
    }
}

