/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.fmt.Verbose;
import java.io.IOException;

public class TinyClient {
    CcsServer ccs;

    private int getListLength(String string, int n) throws IOException {
        int n2 = string.length();
        int n3 = 4 + n2 + 1;
        byte[] byArray = new byte[n3];
        CcsServer.writeInt(byArray, 0, n2);
        CcsServer.writeString(byArray, 4, n2 + 1, string);
        CcsServer.Request request2 = this.ccs.sendRequest("ccs_list_len", n, byArray);
        byte[] byArray2 = this.ccs.recvResponse(request2);
        if (byArray2.length < 4) {
            return -1;
        }
        return CcsServer.readInt(byArray2, 0);
    }

    private byte[] byteList(String string, String string2, int n, int n2, int n3) throws IOException {
        int n4 = string.length();
        int n5 = 16 + n4 + 1;
        byte[] byArray = new byte[n5];
        CcsServer.writeInt(byArray, 0, n2);
        CcsServer.writeInt(byArray, 4, n3);
        CcsServer.writeInt(byArray, 8, 0);
        CcsServer.writeInt(byArray, 12, n4);
        CcsServer.writeString(byArray, 16, n4 + 1, string);
        CcsServer.Request request2 = this.ccs.sendRequest("ccs_list_items." + string2, n, byArray);
        byte[] byArray2 = this.ccs.recvResponse(request2);
        return byArray2;
    }

    private String stringList(String string, int n, int n2, int n3) throws IOException {
        return new String(this.byteList(string, "txt", n, n2, n3));
    }

    private void decodeList(byte[] byArray) {
        Verbose verbose = new Verbose();
        verbose.decode(byArray);
    }

    public TinyClient(CcsServer ccsServer, String string, int n) {
        this.ccs = ccsServer;
        if (string == null) {
            string = "converse/lists";
        }
        try {
            int n2 = this.getListLength(string, n);
            System.out.println("Cpd list " + string + " contains " + n2 + " items");
            String string2 = this.stringList(string, n, 0, n2);
            System.out.println("\n------ Text version: \n" + string2);
            byte[] byArray = this.byteList(string, "fmt", n, 0, n2);
            System.out.println("\n------ Binary version (" + byArray.length + " bytes)");
            this.decodeList(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java client <host> <port> [ <list> [ <pe> ] ]");
            System.exit(1);
        }
        String[] stringArray2 = new String[]{stringArray[0], stringArray[1]};
        CcsServer ccsServer = CcsServer.create(stringArray2, false);
        System.out.println("Connected: The CCS server has " + ccsServer.getNumPes() + " processors.");
        String string = null;
        int n = 0;
        if (stringArray.length > 2) {
            string = stringArray[2];
        }
        if (stringArray.length > 3) {
            n = Integer.parseInt(stringArray[3]);
        }
        new TinyClient(ccsServer, string, n);
    }
}

