#include "charm++.h"

extern "C" {
#include "simplemsg.h"
};

#include "main.h"
#include "testcharm.h"
#include "testthreads.h"

void threadFunc(void *);

Testthreads::Testthreads(Msg *msg)
{
  CthThread thread = CthCreate((CthVoidFn)&(threadFunc),(void*)0,0);
  CthSetStrategyDefault(thread);
  CthAwaken(thread);
}

void threadFunc(void *arg)
{
  int i, rtag;
  SMsg *smsg;
  for(i=0;i<NMSGS;i++) {
    smsg = new SMsg;
    CsmTVRecv(1, &i, (void *)smsg, sizeof(SMsg), &rtag);
    // CPrintf("rtag=%d\tData=%d\n", rtag, smsg->data);
    delete smsg;
  }
  Msg *msg = new Msg;
  msg->data=3;
  CProxy_main pmain(mainhandle);
  pmain.testend(msg);
}

#include "testthreads.def.h"

