#include <stdio.h>
#include "schedtest.h"

main::main(CkArgMsg *m)
{
  CProxy_test::ckNew(new InitMsg);
  delete m;
}

test::test(InitMsg *msg)
{
  msg_count = 0;
  starttimer = CkTimer();
  CProxy_test pt(thishandle);
  pt.process(msg);
}

void test::process(InitMsg *msg)
{
  msg_count++;
  if(msg_count == NMSG) {
    endtimer = CkTimer();
    timeTaken1 = (endtimer-starttimer);
    msg_count = 0;
    starttimer = CkTimer();
    CProxy_test pt(thishandle);
    pt.process_t(msg);
  } else {
    CProxy_test pt(thishandle);
    pt.process(msg);
  }
}

void test::process_t(InitMsg *msg)
{
  msg_count++;
  if(msg_count == NMSG) {
    endtimer = CkTimer();
    timeTaken2 = (endtimer-starttimer);
    CkPrintf("Scheduling Overhead:\n");
    CkPrintf("\tNon-Threaded:\t%lf microseconds\n",(timeTaken1/NMSG)*(1.0e6));
    CkPrintf("\tThreaded    :\t%lf microseconds\n",(timeTaken2/NMSG)*(1.0e6));
    CkExit();
  } else {
    CProxy_test pt(thishandle);
    pt.process_t(msg);
  }
}

#include "schedtest.def.h"
