#include "ddt.h"

DDT ddt ;

main(int argc, char* argv)
{
	DDT_Type	oneSlice ;
	DDT_Type	twoSlice ;
	DDT_Type	newArr ;

	int arr[6][6] ;
	int bArr[6][6] ;

	
	printf("Orig Array is \n");
	for(int i = 0 ; i < 6; i++ )
	{
		for(int j = 0; j < 6 ; j++)
		{
			arr[i][j] = (i*6 + j ) + 1;
			printf("%d", arr[i][j]);
			bArr[i][j] = 0 ;
			printf("  ");
		}
		printf("\n");
	}

	
	// Testing Contigous & Vector
	ddt.Type_Contiguous(3, DDT_INT, &oneSlice) ;
	ddt.Type_Vector(6,1,2, oneSlice, &newArr);

	DDT_Send(arr,1,  newArr , bArr);

	printf("Changed Array is \n");
	for(int i = 0 ; i < 6; i++ )
	{
		for(int j = 0; j < 6 ; j++)
		{
			printf("%ld", bArr[i][j]);
			printf("  ");
		}
		printf("\n");
	}
	

	/* Testing Vector & HVector */
	
	ddt.Type_Vector(6,1,6, DDT_INT , &oneSlice);
	ddt.Type_HVector(6,1, sizeof(int), oneSlice, &twoSlice);

	DDT_Send(arr, 1, twoSlice, bArr );
	printf("Changed Array is \n");
	for(int i = 0 ; i < 6; i++ )
	{
		for(int j = 0; j < 6 ; j++)
		{
			printf("%d", bArr[i][j]);
			printf("  ");
		}
		printf("\n");
	}
	*/

	
	//Testing AMPI_Type_Indexed	
	int	disp[10], blocklen[10] ;
	DDT_Type	upper ;
	int a[10][10] ;
	int b[10][10] ;

	printf("original Array is \n");
	for(int i = 0; i < 10; i++)
	{
		for(int j = 0 ; j < 10 ; j++)
		{
			a[i][j] = j+1 ;
			printf("%d ", a[i][j]);
		}
		disp[i] = 10 * i + i ;
		blocklen[i] = 10 -i ;
		printf("\n");
	}

	ddt.Type_Indexed(10, blocklen, disp, DDT_INT, &upper);

	DDT_Send(a, 1, upper, b);
	printf("\n new Array is \n");
	for(int i = 0; i < 6; i++)
	{
		for(int j = 0 ; j < 10 ; j++)
		{
			printf("%d ", b[i][j] );
		}
		printf("\n");
	}
	
}
