#include <stdio.h>
#include "hello.decl.h"

CkChareID mid;
CProxy_Hello arr;

class HiMsg : public CMessage_HiMsg
{
public:
  int data;
	 HiMsg(int n) {data=n;}
};

class main : public Chare
{
public:
  main(CkMigrateMessage *m) {}
  main(CkArgMsg* m)
  {
    if(m->argc < 2) {
      CkAbort("Usage: hello <nElements>\n");
    }
    int nElements = atoi(m->argv[1]);
    delete m;
    CkPrintf("Running Hello on %d processors for %d elements\n",
	     CkNumPes(),nElements);
    mid = thishandle;

    arr = CProxy_Hello::ckNew(nElements);

    arr[0].SayHi(new HiMsg(17));
  };

  void maindone(void)
  {
    CkPrintf("All done\n");
    CkExit();
  };
};

class Hello : public ArrayElement1D
{
public:
  Hello()
  {
    CkPrintf("Hello %d created\n",thisIndex);
  }

  Hello(CkMigrateMessage *m) {}
  
  void SayHi(HiMsg *m)
  {
    CkPrintf("Hi[%d] from element %d\n",m->data,thisIndex);
    if (thisIndex < numElements-1) {
      arr[thisIndex+1].SayHi(m);
    } else {
      CProxy_main(mid).maindone();
      delete m;
    }
  }
};

#include "hello.def.h"
