      MODULE  HelloMod
      TYPE Hello
      integer data
      END TYPE

!    define Object Pointer used to communicate with charm kernel
      TYPE HelloPtr
      TYPE (Hello), POINTER ::  obj
      integer*8 aid
      END TYPE

      END MODULE

!    this subroutine can be generated automatically
      SUBROUTINE Hello_allocate(objPtr, aid, index)
      USE HelloMod
      TYPE(HelloPtr) objPtr 
      integer*8 aid
      integer index

      allocate(objPtr%obj)
      objPtr%aid = aid
!     set Chare data here in constructor
      objPtr%obj%data = index
      END SUBROUTINE

!    define fortran entry function
      SUBROUTINE SayHi(objPtr, myIndex, data, data2, s)
      USE HelloMod
      IMPLICIT NONE

      TYPE(HelloPtr) objPtr
      integer myIndex
      integer data
      double precision data2
      integer si
      integer  s(4)
      integer chunkSize, myPe

! print parameters
      call CkMyPe(myPe)
      call CkPrintf("[%d] SayHi: myIndex:%d data:%d data2:%F\n$$", myPe, myIndex, data, data2)
      call CkPrintf("SayHi: s: %d %d %d %d\n$$",s(1), s(2), s(3), s(4))

!  get readonly variable
      call get_ChunkSize(chunkSize)
      call CkPrintf("chunkSize(readonly):%d \n$$", chunkSize)

!  get Chare data
      call CkPrintf("data: %d\n$$", objPtr%obj%data)

      if (myIndex < 4) then
          call SendTo_Hello_SayHi(objPtr%aid, myIndex+1, 1, data2, s);
      else 
	  call CkExit()
      endif

      END SUBROUTINE


      SUBROUTINE f90charmmain()
      USE HelloMod
      integer i
      double precision d
      integer*8 aid
      integer  s(8)

      call Hello_CkNew(5, aid)

      call set_ChunkSize(10);

      do i=1,8
	  s(i) = i;
      enddo
      d = 2.50
      call SendTo_Hello_SayHi(aid, 0, 1, d, s(3:6));

      END

