recursive subroutine AMPI_Main
  use ampi
  implicit none

  integer :: thisIndex, ierr, nblocks, i
  double precision :: inval, outval, expect

  call AMPI_Init(ierr)
  call AMPI_Comm_rank(AMPI_COMM_WORLD, thisIndex, ierr)
  call AMPI_Comm_size(AMPI_COMM_WORLD, nblocks, ierr)

  inval = thisIndex + 1
  call AMPI_Allreduce(inval, outval, 1, AMPI_DOUBLE_PRECISION, AMPI_SUM, &
&                     AMPI_COMM_WORLD, ierr)

  expect = (nblocks*(nblocks+1))/2
  if (outval .eq. expect) then
    call AMPI_Print('allreduce test passed')
  else
    call AMPI_Print('allreduce test failed')
  end if
  call AMPI_Finalize(ierr)

end subroutine
