#include <netinet/in.h> /* for sockaddr_in */
#include <ifaddrs.h> /* for getifaddrs */
#include <net/if.h> /* for IFF_RUNNING */

int main()
{
  struct ifaddrs *interfaces=0;
  if( getifaddrs(&interfaces) == 0 ) {
        struct ifaddrs *interface;
        for( interface=interfaces; interface; interface=interface->ifa_next ) {
            if( (interface->ifa_flags & IFF_UP) && ! (interface->ifa_flags & IFF_LOOPBACK) ) {
                const struct sockaddr_in *addr = (const struct sockaddr_in*)interface->ifa_addr;
                if( addr && addr->sin_family==AF_INET ) {
                    break;
                }
            }
        }
        freeifaddrs(interfaces);
  }
}
